/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DIndex.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;

import java.util.ArrayList;

/**
 * Creates automatically an index in the document. To render the index the driver
 * uses the index entries which have the same property that the index.
 * The index has a property to able to create different index in a document.
 * <br><br>
 * <b>This item is not actually implemented by the drivers.
 * It will be implemented in the next version. </b>
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DIndex extends DItem implements IDParagraphItem, IDTaggedItem 
{
   private String property = null;
   private Object value = null;
   private String tag = null;
   
   /**
    * Creates a DIndex with a property named _name and a value _value.
    */
   public DIndex(String _name, Object _value) 
   {
      property = _name;
      value = _value;    
   }
   
   /**
    * Creates an index with a null property.
   */
   public DIndex() 
   {
    
   }
   
   /**
    * Access method for the property property.
    * 
    * @return   the current value of the property property
    */
   public java.lang.String getProperty() 
   {
      return property;    
   }
   
   /**
    * Sets the value of the property property.
    * 
    * @param aProperty the new value of the property property
    */
   public void setProperty(java.lang.String aProperty) 
   {
      property = aProperty;    
   }
   
   /**
    * Access method for the value property.
    * 
    * @return   the current value of the value property
    */
   public java.lang.Object getValue() 
   {
      return value;    
   }
   
   /**
    * Sets the value of the value property.
    * 
    * @param aValue the new value of the value property
    */
   public void setValue(java.lang.Object aValue) 
   {
      value = aValue;    
   }
   
   /**
    * Access method for the tag property.
    * 
    * @return   the current value of the tag property
    */
   public java.lang.String getTag() 
   {
      return tag;    
   }
   
   /**
    * Sets the value of the tag property.
    * 
    * @param aTag the new value of the tag property
    */
   public void setTag(java.lang.String aTag) 
   {
      tag = aTag;    
   }
   
   /**
    * Returns the entries of the index which match with the index property
    * Not yet implemented will be in next version
    */
   public ArrayList getEntries() 
   {
   	  IDItem doc = getRoot();
   	  if (doc==null) return null;
   	  
   	  ArrayList retval = new ArrayList();
   	  
   	  IDItemIterator it = doc.getIterator();
   	  
   	  for (IDItem i = it.getFirst(); i!=null; i=it.getNext())
   	  {
   	     if (i instanceof DIndexEntry)
   	     {
   	     	DIndexEntry ide = (DIndexEntry)i;
   	     	if (ide.getProperties().get(property).equals(value))
   	     	   retval.add(i);
   	     }
   	  }
   	  
   	  return retval;
   }
}
