/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DIndexEntry.java,v 1.2 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;


/**
 * A DIndexEntry is an index entry. For example if you want to create an index of 
 * all pictures in the document, you add an entry with the property 'picture' in 
 * front of each image.
 * A DIndex entry is an IDTaggedItem, you can reference it with an IDLink.
 * <br><br>
 * <b>This item is not actually implemented by the drivers.
 * It will be implemented in the next version. </b>
 * 
 * @see IDLink 
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DIndexEntry extends DItemContainer implements IDTaggedItem, IDParagraphItem 
{
   /** Property store. */
   private DPropertyStore properties = new DPropertyStore();
   private String tag = null;
   
   /**
    * Creates a DIndexEntry with a null property.
    */
   public DIndexEntry() 
   {}
   
   /** Return property store  */
   public DPropertyStore getProperties() { return properties; }
   
   /**
    * Creates a DIndexEntry with property named 'prop' and associated value 'v'.
    * 
    * @param _prop name of the property
    * @param _value value of the property
    */
   public DIndexEntry(String _prop, Object _value) 
   {
       getProperties().store(_prop, _value);    
   }
   
   /**
    * Returns the tag
    */
   public String getTag() 
   {
    return tag;
   }
   
   /**
    * Sets the tag.
    * 
    * @param _tag is a unique string characters.
    */
   public void setTag(String _tag) 
   {
      tag = _tag;
   }
}

