/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DItem.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;


/**
 * A DItem is defined by a parent item, a next item and a style. 
 * A DItem can't have children, it's a leaf object. This is the based object
 * for all other item of a document in the JScrib core.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public abstract class DItem implements IDItem 
{
   private IDStyle style = null;
   private IDItem next = null;
   private IDItem parent = null;
   
   /**
    * Creates a DItem with no next and parent IDItem and no style.
    */
   public DItem() 
   {}
   
   /**
    * Detaches the item from a document and clears its style.
    */
   public void clear() 
   {
       parent = null;
       next   = null;
       style  = null;    
   }
   
   /**
    * Returns the top level parent item in a IDItem hierarchy.
    * Generally this item is a IDDocument item in a valid JScrib document.
    */
   public IDItem getRoot() 
   {
   	  IDItem retval;
   	 
   	  for (retval = this; retval != null && retval.getParent() != null;) 
   	  { 
   	   	  retval = retval.getParent();
   	  } 
   	 
      return retval;    
   }
   
   /**
    * Returns the next item. It is the sibling of the current item.
    */
   public IDItem getNext() 
   {
    return next;    
   }
   
   /**
    * Returns the Applied style of the item. If the current item has'nt a style
    * this method search a parent IDItem that has a style.<br>
    * This method can return null if no parent IDItem have a style.<br>
    * To give the style of the IDItem use method getStyle
    * 
    * @see #getStyle
    */
   public IDStyle getAppliedStyle() 
   {
   	IDStyle retval = null;
   	
	if (style != null)
		retval = style;
    else
	if (getParent() != null)
		retval = getParent().getAppliedStyle();    
    
    return retval;    
   }

   /**
	* Returns the style of the item.
	* 
	* @see #setStyle
	* @see #getAppliedStyle
	*/
   public IDStyle getStyle() 
   {
	 return style;    
   }
   
   /**
    * Sets the next IDItem.
    */
   public void setNext(IDItem i) 
   {
   	  next = i;    
   }
   
   /**
    * Sets the style of the item.
    * 
    * @see #getStyle()
    */
   public void setStyle(IDStyle style) 
   {
      this.style = style;    
   }
   
   /**
    * Inserts a child after the last IDItem child. This method
    * calls getLastChildren before calling insertChild. It is no
    * very efficient.
    *  
    * @see #insertChild
    * @see #getLastChild
    */
   public boolean addChild(IDItem item) 
   {
    return insertChild(item, getLastChild());    
   }
   
   /**
    * Returns the number of children of the item. This method returns always 0 because
    * an IDItem can contains children because it is a leaf in a document. 
    */
   public int getChildCount() 
   {
    return 0;
   }
   
   /**
    * Returns the position of the child passed in argument. 
    * If the return value is -1, that means that the item has not be found in item 
    * children. This method returns always -1 because an IDItem can contains children.
    */
   public int getChildPosition(IDItem i) 
   {
    return -1;    
   }
   
   /**
    * Returns the first child of the item.  This method returns always null because
    * an IDItem can contains children. 
    * 
    * @see #getLastChild
    * @see #getChildPosition
    */
   public IDItem getFirstChild() 
   {
    return null;
   }
   
   /**
    * Returns the iterator of the item.
    */
   public IDItemIterator getIterator() 
   {
    return new DItemIterator(this);    
   }
   
   /**
    * Returns the last child of the item. This method returns always null because
    * an IDItem can contains children. 
    *
    * @see #getFirstChild
    * @see #getChildPosition
    */
   public IDItem getLastChild() 
   {
    return null;
   }
   
   /**
    * Inserts the child 'item' to the item after the child 'after'.
    * This method returns always false because IDItem can contains children. 
    * @param child item to be added
    * @param after item after which the child should be added
    * @return true if the insertion has succed, false in othercase.
    *
    * @see #addChild
    * @see #removeChild
    */
   public boolean insertChild(IDItem item, IDItem after) 
   {
    return false;    
   }
   
   /**
    * Return true if the item is a container.
    * This method returns always false because IDItem can contains children.
    * 
    * @see DItemContainer#isContainer 
    */
   public boolean isContainer() 
   {
    return false;    
   }
   
   /**
    * Removes the child 'item' from the item children and returns true. 
    * Returns false if the item to remove isn't found in the child list.
    * This method returns always true because IDItem can contains children.  
    *
    * @see #insertChild
    * @see #addChild
    */
   public boolean removeChild(IDItem item) 
   {
    return true;
   }
   
   /**
    * Sets the parent of the item. No control is applied by this method.<br>
    * <b>DO NOT USE DIRECTLY IT</b>
    * to add an item in a container. Prefer to use {@link #insertChild} method
    * @see #getParent
    */
   public void setParent(IDItem p) 
   {
      parent = p;    
   }
   
   /**
    * Returns the parent item. 
    * @see #setParent
    */
   public IDItem getParent() 
   {
    return parent;    
   }
}
