/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DItemContainer.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;

import java.util.LinkedList;
import java.util.List;


/**
 * A DItemContainer is a container which contains IDItem. 
 * It is useful to replace an IDItem when you want to insert child in it because it 
 * is impossible with an IDItem which is a leaf element.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public abstract class DItemContainer extends DItem 
{
   private IDItem child = null;
   
   /**
    * Constructs the DItemContainer.
    */
   public DItemContainer() 
   {}
   
   /**
    * Returns the last child of the item container. 
    * 
    * @see #getFirstChild
    * @see #getChildPosition
    */
   public IDItem getLastChild() 
   {
   	  IDItem c = null;
   	  for (c = getFirstChild(); c != null; c = c.getNext())
   	  {
   	  	if (c.getNext() == null)
   	  	    return c;
   	  }
   	     	  
      return c;    
   }
   
   /**
    * Removes the child 'item' from the item container children and returns true. 
    * Returns false if the item to remove isn't found in the child list. 
    * 
    * @see #insertChild
    * @see #addChild
    */
   public boolean removeChild(IDItem item) 
   {
   	  if ((item == null) || (child == null)) return false;
   	
   	  if (item == child)
   	  {
   	  	 child = child.getNext();
   	  }
   	  else
   	  {
		IDItem c = null;
	    for (c = child; c != null; c = c.getNext())
	    {
	    	if (c.getNext() == item)
	    	{
	    		c.setNext(item.getNext());
	    		break;
	    	}
	    }
   	  }
   	
   	  item.setParent(null);
   	  item.setNext(null);
   	  
      return true;    
   }
   
   /**
    * Inserts the child 'item' to the item container after the child 'after'.
    * 
    * @param child item to be added
    * @param after item after which the child should be added
    * 
    * @see DItemContainer#addChild
    * @see DItemContainer#removeChild
    */
   public boolean insertChild(IDItem _child, IDItem after) 
   {
   	  if (!DChildrenController.acceptChild( this, _child)) return false;
   	
   	  _child.setParent(this);
   	  if (after != null)
   	  {	 
   	  	 IDItem aux = after.getNext();
   	  	 after.setNext(_child);
   	  	 _child.setNext(aux);
   	  }
   	  else
   	  {
   	  	_child.setNext(child);
   	  	 child = (IDItem)_child;
   	  }
   	  
   	  return true;    
   }
   
   /**
    * Returns the first child of the container. 
    * 
    * @see DItemContainer#getLastChild
    * @see DItemContainer#getChildPosition
    */
   public IDItem getFirstChild() 
   {
    return child;    
   }
   
   /**
    * Removes all children item in the container.
    */
   public void clear() 
   {
	   IDItem c = null;
	   for (c = getFirstChild(); c != null; )
	   {
	   	  IDItem n = c.getNext();
		  c.clear();  
		  c = n;
	   }
	   
	   child = null;
	   super.clear();    
   }
   
   /**
    * Returns the number of children of the container.
    */
   public int getChildCount() 
   {
	   IDItem c = null;
	   int cpt = 0;
	   for (c = getFirstChild(); c != null; c = c.getNext())
	   {
	   	  cpt = cpt + 1;
	   }
       return cpt;    
   }
   
   /**
    * Returns the position in the children list of the child passed in argument. 
    * 
    * If the return value is -1, that means that the item has not be found in item 
    * children.
    */
   public int getChildPosition(IDItem i) 
   {
	  IDItem c = null;
      int cpt = 0;
	  for (c = getFirstChild(); c != null; c = c.getNext())
	  {
		  cpt = cpt + 1;
          if (c == i)
              return cpt;
	  }
      return -1;    
   }
   
   /**
    * Returns the list which is contains all children which derive of the class
    * clazz
    */
   public List getChildrenOfClass(Class clazz) 
   {
	  LinkedList list = new LinkedList();	  
      for (IDItem c = getFirstChild(); c != null; c = c.getNext())
	  {
          if (c.getClass().isAssignableFrom(clazz)) list.add(c); 
	  }
      return list;    
   }
   
   /**
    * Returns the first IDItem which derives of the class clazz
    * null if an IDItem has not be found.
    */
   public IDItem getChildOfClass(Class clazz) 
   {	  
      for (IDItem c = getFirstChild(); c != null; c = c.getNext())
	  {
          if (c.getClass().isAssignableFrom(clazz)) return c; 
	  }
      return null;
   }
   
   /**
    * Return always true because the item is a container. 
    *
    * @see DItem#isContainer
    */
   public boolean isContainer() 
   {
    return true;
   }
}
