/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DItemIterator.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;

//TODO: a voir remplacer par une interface iterator java.util.Iterator

/**
 * DItemIterator provides a way to parse all IDItem of a document hierarchy
 * in deep before.<br>
 * The following example prints all text in a document<br>
 * <pre>
 * IDItem doc = new DDocument();
 * ...
 * DItemIterator it = new DItemIterator(doc);
 * for (IDItem c = it.getFirst(); c != null; c = c.getNext())
 * {
 *   if (c instanceof IDTextualItem)
 *      System.out.println((((IDTextualItem)c).getText());
 * }
 * 
 * </pre>
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DItemIterator implements IDItemIterator 
{
   private IDItem current = null;
   private IDItem item = null;
   
   
   /**
    * Creates a DItemIterator. The current item is set with the item passed in 
    * parameter. 
    */
   public DItemIterator(IDItem item) 
   {
      current = item;    
      this.item = current;    
   }
   
   /**
    * Access method for the current property.
    * 
    * @return   the current value of the current property
    */
   public IDItem getCurrent() 
   {
    return current;    
   }
   
   /**
    * Sets the value of the current property.
    * 
    * @param aCurrent the new value of the current property
    */
   public void setCurrent(IDItem aCurrent) 
   {
      current = aCurrent;
      item = aCurrent;    
   }
   


   /**
    * Returns the first item of the iterator.  
    * 
    * @see DItemIterator#getLast
    * @see DItemIterator#getNext
    */
   public IDItem getFirst() 
   {
   	  if (item == null) return null;
   	  
   	  current = item;
   	  return current;    
   }
   
   /**
    * Returns the deepest item. 
    * 
    * @see DItemIterator#getFirst
    * @see DItemIterator#getNext
    */
   public IDItem getLast() 
   {
   	  if (current == null) current = item;
   	
   	  IDItem i = null;
   	  IDItem prev = null;
	  for (i = getCurrent(); i != null; i = getNext())
	  {
	  	prev = i;
	  }
	  current = prev;
	  return prev;    
   }
   
   /**
    * Returns the next item: first child if it exists or brother. 
    * 
    * @see DItemIterator#getLast
    * @see DItemIterator#getFirst
    */
   public IDItem getNext() 
   {
   	if (current == null) return current;
   	
   	if (current.getFirstChild() != null)  
   	{
   		current = current.getFirstChild();
   	}
   	else
   	if (current.getNext() != null)
   	{
   		current = current.getNext();
   	}
   	else
   	{
   	   current = current.getParent();
   
   	   if (current == item)
   	   { 
   	       current = null;
   	       return current;
   	   }
   	   
   	   
   	   while (current != null)
   	   {
   	      if (current.getNext() != null)
   	      {
   	      	  current = current.getNext();
   	      	  return current;
   	      }
   	      
   	      current = current.getParent();
   	      
   	      if (current == item)
   	      { 
   	      	current = null;
   	      	return current;
   	      }
   	   }
   	}
   	
   
    return current;    
   }
}
