/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DLine.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;


/**
 * A DLine is a line separator. You can add a parameter in the constructor to set 
 * the line width in pixel, the default value is 1.
 * Tip: It's a good idea to set line size bigger than 1 pixel if you want to use vertical gradient lines.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DLine extends DItem implements IDParagraphItem 
{
   /** Line Type: define a solid line using applied foreground color */
   public static final String SOLID     = "SOLID.DLine.jscrib"; //$NON-NLS-1$
   /** Line Type: define an horizontal gradient from foreground color to background color (left to right) */
   public static final String HGRADIENT = "HGRADRIENT.DLine.jscrib"; //$NON-NLS-1$
   /** Line Type: define an horizontal  gradient from background color to foreground color (left to right) */
   public static final String HGRADIENTR = "HGRADRIENTR.DLine.jscrib"; //$NON-NLS-1$
   /** Line Type: define an horizontal gradient from foreground color to background color to foreground (left to right)*/
   public static final String HGRADIENT2 = "HGRADRIENT2.DLine.jscrib"; //$NON-NLS-1$
   /** Line Type: define an horizontal gradient from background color to foreground color to background (left to right) */
   public static final String HGRADIENT2R = "HGRADRIENT2R.DLine.jscrib"; //$NON-NLS-1$
   /** Line Type: define an vertical gradient from foreground color to background color (top to bottom) */
   public static final String VGRADIENT = "VGRADRIENT.DLine.jscrib"; //$NON-NLS-1$
   /** Line Type: define an vertical  gradient from background color to foreground color (top to bottom) */
   public static final String VGRADIENTR = "VGRADRIENTR.DLine.jscrib"; //$NON-NLS-1$
   /** Line Type: define an vertical gradient from foreground color to background color to foreground (top to bottom)*/
   public static final String VGRADIENT2 = "VGRADRIENT2.DLine.jscrib"; //$NON-NLS-1$
   /** Line Type: define an vertical gradient from background color to foreground color to background (top to bottom)*/
   public static final String VGRADIENT2R = "VGRADRIENT2R.DLine.jscrib"; //$NON-NLS-1$
   
   public static final int DEFAULT_SIZE = 1;
   public static final String DEFAULT_TYPE = SOLID;
   
   
   private int size;
   private String type;
   
   /**
    * Constructs a DLine with defaults
    */
   public DLine() 
   {
      size=DEFAULT_SIZE;
      type=DEFAULT_TYPE;
   }
   
   /**
    * Constructs a DLine
    */
   public DLine( int size, String type ) 
   {
      this.size=size;
      this.type=type;
   }

   /**
    * Access method for the size property.
    * 
    * @return   the current value of the size property
    */
   public int getSize() 
   {
    return size;    
   }
   
   /**
    * Sets the value of the size property.
    * 
    * @param aSize the new value of the size property
    */
   public void setSize(int aSize) 
   {
      size = aSize;    
   }
   
   /**
    * @return current line type, @see SOLID, HGRADIENT...
    */
   public String getType()
   {
     return type;
   }

   /**
    * Change current line type, @see SOLID, HGRADIENT...
    * (using prior DLine defined string values)
    */
   public void setType(String _type)
   {
     type = _type;     
     if( type == null ) { type = SOLID; return; }//default
     //use core defined constant rather than user one if ...
     if( type == SOLID ) return ;
     if( type == HGRADIENT ) return ;
     if( type == HGRADIENT2 ) return ;
     if( type.equals( SOLID ) ) { type=SOLID; return ; }
     if( type.equals( HGRADIENT   ) ) { type=HGRADIENT;   return ; }
     if( type.equals( HGRADIENTR  ) ) { type=HGRADIENTR;  return ; }
     if( type.equals( HGRADIENT2  ) ) { type=HGRADIENT2;  return ; }
     if( type.equals( HGRADIENT2R ) ) { type=HGRADIENT2R; return ; }
     if( type.equals( VGRADIENT   ) ) { type=VGRADIENT;   return ; }
     if( type.equals( VGRADIENTR  ) ) { type=VGRADIENTR;  return ; }
     if( type.equals( VGRADIENT2  ) ) { type=VGRADIENT2;  return ; }
     if( type.equals( VGRADIENT2R ) ) { type=VGRADIENT2R; return ; }
   }
   
   /**
    * @return true if given line type is the current type of the line.
    */
   public boolean isType( String _type )
   {
     if ( type==null) type = SOLID;
     if( type==_type ) return true;
     if( type.equals( _type ) ) return true;
     return false;
   }

}
