/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DLink.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;

/**
 * A DLink allows to define links in a document and create hypertext document. by 
 * referencing a DTag.
 * A DLink describes a link to a document, a section and a tag. The target is 
 * described as a string. 
 * @see DLinkUtil utility class
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DLink extends DItemContainer implements IDParagraphItem, IDLink
{
   private String target;
   
   /**
    * Creates a DLink whose target is the parameter target. 
   */
   public DLink(String target) 
   {
      setTarget(target);
   } 

   /**
    * Creates a DLink whose target is a_path and method is a_method.
    * <br><b>path must not specify any method.</b>
    * @param a_method a method identifier from IDLink interface.
    * @param a_target target of the link.
    */
   public DLink( String a_method, String a_path ) 
   {
     setTarget( DLinkUtil.buildTarget( a_method, a_path ) );
   } 
      
   /**
    * Creates a DLink with an empty target.
   */
   public DLink() 
   {
     setTarget(null);
   }
   
   /**
    * Returns the link target
    * @see IDLink#getTarget()
    */
   public String getTarget() 
   {
      return target;    
   }
   
   /**
    * Returns this
    * @see IDLink#getLinkedItem
    */
   public IDItem getLinkedItem() 
   {
     return this;
   }
   
   /**
    * Sets the target (method and path) for this link. If a_target is null
    * this method sets automatically <b>linktarget</b> as a target. 
    * @see DLinkUtil#buildTarget
    */
   public void setTarget( String a_target )
   {
     target = a_target==null ? "linktarget" : a_target; //$NON-NLS-1$
   }
}

