/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DLinkUtil.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 26 nov. 2003
 *
 */
package org.eclipse.tptp.platform.report.core.internal;

import java.util.ArrayList;


/**
 * Provides utility code and link's method definition for IDLink implementors.
 * @see IDLink 
 * @see DLink
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DLinkUtil
{
   /**
    * Link property: when the user clicks on this type of link document is moved to target.
    */
   public static final String DEFAULT_LINK = "jscrib-link"; //$NON-NLS-1$

   /**
    * Link property: when the user clicks on this type of link the popup is opened in 
    * another JScrib UI viewer
    */
   public static final String DETACH = "jscrib-detach"; //$NON-NLS-1$
   
   /**
    * Default link property: when the user clicks on the link the popup is opened.
    */
   public static final String POINTER = "jscrib-popup" ; //$NON-NLS-1$
   
   /**
    * Link property: when the mouse pointer enters the link area the popup appears 
    * automatically
    */
   public static final String TOOLTIP = "jscrib-tooltip"; //$NON-NLS-1$
   
   /**
    * Returns true if the link's method is internal, false if the target is an URL.
    * @return boolean
    */
   public static final boolean isInternalLink( IDLink a_link ) 
   { 
     return isInternalLink( a_link.getTarget() );
   }
     
   /**
    * Returns true if the link's target is internal method, false if the target is an URL.
    */
   public static boolean isInternalLink( String a_target ) 
   { 
     String method = getMethod( a_target );
     if( DEFAULT_LINK.equals( method ) ) return true;
     if( DETACH.equals( method ) ) return true;
     if( POINTER.equals( method ) ) return true;
     if( TOOLTIP.equals( method ) ) return true;
     return false;
   }
     
   /**
    * return true is method is a popup-like method.
    */
   public static boolean isPopupLink( IDLink a_link )
   {
     String method = getMethod( a_link );
     if( DETACH.equals( method ) ) return true;
     if( POINTER.equals( method ) ) return true;
     if( TOOLTIP.equals( method ) ) return true;
     return false;       
   }
     
   /**
    * Returns method of target link a_target. In JScrib a link has the following
    * syntax:<code>[&lt;method&gt;:&lt;path&gt]</code><br> 
    * 
    * In JScrib by default there are two
    * link methods (internal / external). An internal method is named jscrib-link.
    * All another names represent an external link (ex: http, file, etc...).
    * A link with an internal method references an IDTaggedItem in the current 
    * document or in another. 
    * 
    * @see #getPath  
    */
    public static String getMethod( String a_target ) 
    {
       if( a_target == null ) return null;
       String method = DEFAULT_LINK;
    
       int idx = a_target.indexOf(":"); //$NON-NLS-1$
       int idx2 = a_target.indexOf("/"); //$NON-NLS-1$
       // have ':' before optional '/'  ?
       if (idx > -1 && ( idx2<0 || idx2>idx ) )
       {
         method = a_target.substring(0, idx);
       }
      
       return method;
    }
      
    /**
     * @see DLinkUtil#getMethod(java.lang.String)
     */
    public static final String getMethod( IDLink a_link )
    {
      return getMethod( a_link.getTarget() );
    }
       
   /**
    * Returns the path of a string link. 
    * For an internal method the path is the list of parent items with
    * the tag name at the end. Each path items are separated by '/' character.
    * In othercase the path can be an URL, user reference, etc..
    * 
    * @see #getPathItems
    */
    public static String getPath( String a_target ) 
    {
       String path = a_target;
      
      int idx = a_target.indexOf(":"); //$NON-NLS-1$
      int idx2 = a_target.indexOf("/"); //$NON-NLS-1$
      if (idx > -1 && idx2>idx )
      {
        path   = a_target.substring(idx+1);
      }else{
        if(idx2==-1 && idx>-1)
        {
          path   = a_target.substring(idx+1);
        }
      }
      
      return path;
    }
      
    /**
     * @see DLinkUtil#getPath(String)
     */
    public static final String getPath( IDLink a_link )
    {
      return getPath( a_link.getTarget() );
    }

    /**
     * Split path of link at '/' char separator, returns each element in an String array.
     * The array item can be null.
     */
    public static String[] getPathItems( IDLink a_link ) 
    {
      String t = getPath( a_link );
  
      int idx = t.indexOf("/"); //$NON-NLS-1$
      ArrayList items = new ArrayList();
      while (idx > -1)
      {
        String w = t.substring(0, idx);
 //       if (w.length() > 0)
 //       {
          items.add(w);
 //       }
        t = t.substring(idx+1);
        idx = t.indexOf("/"); //$NON-NLS-1$
      } 
      items.add(t);
   
      String[] retval = new String[items.size()];
      for (int i = 0; i < items.size(); i = i + 1)
      {
        retval[i] = (String)items.get(i);
      }
      return retval;    
    }
      
    /**
     * Returns the target string (i.e. method ':' path) of the link. If a_method is
     * null an internal link method is used to make the string link.
     * @return string representing target method and path of the link.
     */
    public static String buildTarget( String a_method, String a_target )
    {
    	String m = a_method;
    	if (a_method == null) 
    	   m = DEFAULT_LINK;
        return m+":"+a_target; //$NON-NLS-1$
    }
}


