/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DList.java,v 1.3 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;


/**
 * A DList is a DItemContainer that lists paragraph numbers or paragraph glyph.
 * A DList can contain IDParagraphItem. The children item of a DList are the
 * contents of the list. They will be prefixed by a glyph or a number.
 * 
 *  @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *  
 */
public class DList extends DItemContainer implements IDParagraphItem 
{
   /**
    * cf. Style Number Format
    */
   private int format = DStyle.GLYPH; //default value
   
   /**
    * Creates a DList with format t. 
    */
   public DList(int t) 
   {
   	  setFormat(t);    
   }
   
   /**
    * Creates a DList with GLYPH format by default.
    */
   public DList() 
   {}
   
   /**
    * Access method for the format property.
    * @see DStyle#getNumberingFormat
    * 
    * @return   the current value of the format property
    */
   public int getFormat() 
   {
      return format;    
   }
   
   /**
    * Sets the value of the format property. The values are defined in the
    * DStyle class.
    * 
    * @param aFormat the new value of the format property
    * @see DStyle
    */
   public void setFormat(int aFormat) 
   {
      format = aFormat;
   }
   
   /**
    * Sets the value of the format property from a string. 
    * The values are defined in the DStyle class.
    * 
    * @param aFormat the new value of the format property
    * @see DStyle
    */
   public void setFormat(String format) 
   {
       if (format.equals("GLYPH.DStyle.core.jscrib")) //$NON-NLS-1$
          this.format = DStyle.GLYPH;
       else
       if (format.equals("LETTER.DStyle.core.jscrib")) //$NON-NLS-1$
          this.format = DStyle.LETTER;
       else
       if (format.equals("NUMBER.DStyle.core.jscrib")) //$NON-NLS-1$
          this.format = DStyle.NUMBER;
       else
       if (format.equals("ROMAN_NUMBER.DStyle.core.jscrib")) //$NON-NLS-1$
          this.format = DStyle.ROMAN_NUMBER;
       else
          this.format = DStyle.NOTHING;
   }
   
   /**
    * Returns the value of the format property as a string. 
    * The values are defined in the DStyle class.
    * @see DStyle
    */
   public String getStringFormat() 
   {
       if (this.format == DStyle.GLYPH)
          return "GLYPH.DStyle.core.jscrib"; //$NON-NLS-1$
       else
       if (this.format == DStyle.LETTER)
          return "LETTER.DStyle.core.jscrib"; //$NON-NLS-1$
       else
       if (this.format == DStyle.NUMBER)
           return "NUMBER.DStyle.core.jscrib"; //$NON-NLS-1$
       else
       if (this.format == DStyle.ROMAN_NUMBER)
           return "ROMAN_NUMBER.DStyle.core.jscrib"; //$NON-NLS-1$
       else
           return "NOTHING.DStyle.core.jscrib"; //$NON-NLS-1$
  }
     
}
