/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DPoint.java,v 1.3 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;


/**
 * A point is a Curve (DCurve) item child containing one or several coordinates 
 * (DCoord) assocated to axis (DAxis).
 * <P>Note: few Graphic types as T_HISTOGRAM (_IM), T_SECTOR (_3D), T_HISTORS and T_STACKBARS,
 * can have <b>label</b> replacing displayed values. Such labels are provided by string
 * contained in a DText item which much be child of DPoint.  Only first DText label
 * is used. To set a blank label use empty string in DText item. Note: multi-lines labels
 * are not supported.
 * <br>labels might be aligned using DAxis.P_LABEL_ALIGNMENT property, refer to DAxis class.
 * @see DCurve
 * @see DCoord
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class DPoint extends DItemContainer
{
   
   /** point's type */
   private String type = DEF_ACTUAL_POINT; 
   /** point's tooltip */
   private String tooltip;
   /** point's id */
   private String id;
    
   /** Actual point type 
    * @see #setType(String) */
   public final static String DEF_ACTUAL_POINT = "actual"; //$NON-NLS-1$
   /** Hole point type
    * @see #setType(String) */
   public final static String DEF_HOLE_POINT = "hole"; //$NON-NLS-1$
   

   
   /**
    * Creates a point without any coordinate.
    */
   public DPoint() 
   {
    
   }
       
   /**
    * @param _axis the axis corresponding to the required coordinate.
    * @return coordinate assicated to the axis, or null if none.
    */
   public DCoord getCoord(DAxis _axis) 
   {
      for( IDItem item=getFirstChild() ; item!=null; item=item.getNext() )
      {
        if( item instanceof DCoord )
        {
          DCoord c = (DCoord)item;
          if( c.getAxis() == _axis ) return c;
        }
      }
      return null;    
   }

   /** @return the point type 
    * Only activated for the SVG generation */
   public String getType() {
      return type;
   }
   
   /** sets the point type 
    * Only activated for the SVG generation */
   public void setType(String type) {
      this.type = type;
   }

   /** @return the tooltip text for the point 
    * Only activated for the SVG generation */
   public String getTooltip() {
    return tooltip;
   }

   /** Sets the point's tooltip text 
    * Only activated for the SVG generation */
   public void setTooltip(String tooltip) {
    this.tooltip = tooltip;
   }
   
   /** @return the point ID 
    * Only activated for the SVG generation */
   public String getId() {
     return id;
   }
   
   /** Sets the point ID 
    * Only activated for the SVG generation */
   public void setId(String id) {
    this.id = id;
   }
}
