/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DPointLink.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 7 nov. 2003
 *
 */
package org.eclipse.tptp.platform.report.core.internal;

/**
 * DPointLink add IDLink ability to a DPoint item.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DPointLink extends DPoint implements IDLink
{
  private String target_;
  
  /**
   * Construct a link curve item with empty default link.
   */
  public DPointLink()
  {
    setTarget(null);
  }

  /**
   * Construct a link curve item with the link target.
   */
  public DPointLink( String a_target )
  {
    setTarget( a_target );
  }
  
  /**
   * Construct a link curve item with the link method and path.
   * For method, @see IDLink interface.
   */
  public DPointLink( String a_method, String a_path )
  {
    setTarget( DLinkUtil.buildTarget( a_method, a_path ) );
  }
  
  /**
   * @see IDLink#getTarget()
   */
  public String getTarget()
  {
    return target_;
  }

  /**
   * @see IDLink#setTarget
   */
  public void setTarget( String a_target )
  {
    target_ = a_target==null ? "notarget" : a_target; //$NON-NLS-1$
  }

  /**
   * @see IDLink#getLinkedItem()
   */
  public IDItem getLinkedItem()
  {
    return this;
  }
}
