/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DPopup.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;


/**
 * DPopup describes the containt of a hidden paragraph wich appears only if the 
 * user clicks on a link. 
 * 
 * @see org.eclipse.tptp.platform.report.core.internal.DLink
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DPopup extends DAbstractParagraph implements IDTaggedItem, IDParagraphItem 
{
   private String tag;
   
   
   /**
    * Creates a popup with a tag and an alignment. 
    * 
    * @see IDAlignment
    */
   public DPopup(String tag, int align) 
   {
   	 super(align);
   	 setTag( tag );
   }
   
   /**
    * Creates a popup with no tag and an alignment. 
    * By default this popup is named 'notag'.
    * 
    * @see IDAlignment
    */
   public DPopup(int align) 
   {
   	 super(align);
   	 setTag(null);
   }
   
   /**
    * Creates a popup with a tag. 
    */
   public DPopup(String tag) 
   {
   	  super();
      setTag( tag );
   }
   
   /**
    * Creates a popup with no tag. By default this popup is named 'notag'.
    */
   public DPopup() 
   {
   	 super();
     setTag(null);
   }
   
   /**
    * Access method for the tag property.
    * 
    * @return   the current value of the tag property
    */
   public java.lang.String getTag() 
   {
    return tag;    
   }
   
   /**
    * Sets the value of the tag property. If aTag is null the tag is
    * automatically set to 'notag'
    * 
    * @param aTag the new value of the tag property
    */
   public void setTag(java.lang.String aTag) 
   {
      tag = aTag==null ? "notag" : aTag ;     //$NON-NLS-1$
   }
   
}
