/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DPropertyStore.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



/*
 * Created on 2 oct. 2003
 *
 */
package org.eclipse.tptp.platform.report.core.internal;

import java.util.HashMap;
import java.util.Map;

/**
 * DPropertyStore purpose is to store values associated with a key (a string).
 * A variety of method is proprosed to facilitate the usage with java primitive 
 * types.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DPropertyStore 
{
   
   /*
    * properties field is created at first store call
    */
   private HashMap properties_;
   
   /**
    * Constructs an empty property store
    */
   public DPropertyStore() 
   {}
   
   /**
    * Returns true if it already exists in the property store a property with the
    * key _key
    */
   public boolean hasKey(String _key) 
   {
    if( properties_==null) return false;
    return properties_.containsKey( _key );    
   }
   
   /**
    * Returns true if the property with the key _key has a value. Value
    * not equal to null.
    */
   public boolean hasValue(String _key) 
   {
    if( properties_==null) return false;
    Object value = properties_.get( _key );
    return value!=null ;    
   }
   
   /**
    * Stores a property, replace any previous same key with new value.
    * A variety of store method exists for each java primitives types.
    */
   public void store(String _key, Object _value) 
   {
    if( properties_==null ) properties_ = new HashMap(64);
    properties_.put( _key, _value );    
   }
   
   /**
    * Removes a property to the store with the key _key.
    */
   public void remove(String _key) 
   {
    if( properties_==null ) return ;
    properties_.remove( _key );    
   }
   
   /**
    * Returns true if the property _key is associated with a non null value 
    * and this value's class is equals to _value_class
    */
   public boolean valueIs(String _key, Class _value_class) 
   {
    if( properties_==null ) return false;
    Object value = properties_.get( _key );
    if( value==null ) return false;
    return value.getClass().equals( _value_class );    
   }
   
   /**
    * Returns the property value stored with the key _key, null if key isn't known.
    * @see #hasValue
    */
   public Object get(String _key) 
   {
    if( properties_==null ) return null;
    return properties_.get( _key );    
   }
   
   /**
    * Returns value assciated with key if stored value is non null, otherwise
    * return default value.
    */
   public Object get(String _key, Object _default_value) 
   {
    Object value = get( _key );
    if ( value ==null ) return _default_value;
    return value;    
   }
   
   /**
    * Specialized store method for a boolean property
    */
   public final void store(String _key, boolean _value) 
   {
    store( _key, new Boolean(_value) );    
   }
   
   /**
    * Specialized store method for a byte property
    */
   public final void store(String _key, byte _value) 
   {
    store( _key, new Byte(_value));    
   }
   
   /**
    * Specialized store method for a short property
    */
   public final void store(String _key, short _value) 
   {
    store( _key, new Short(_value) );    
   }
   
   /**
    * Specialized store method for a int property
    */
   public final void store(String _key, int _value) 
   {
    store( _key, new Integer(_value) );    
   }
   
   /**
    * Specialized store method for a long property
    */
   public final void store(String _key, long _value) 
   {
    store( _key, new Long(_value) );    
   }
   
   /**
    * Specialized store method for a float property
    */
   public final void store(String _key, float _value) 
   {
    store( _key, new Float(_value) );    
   }
   
   /**
    * Specialized store method for a double property
    */
   public final void store(String _key, double _value) 
   {
    store( _key, new Double(_value) );    
   }
   
   /**
    * Specialized get method for a boolean property.
    * @return _default_value if key is unknown, null value is store or key is not 
    * associated with a Boolean value.
    */
   public final boolean get(String _key, boolean _default_value) 
   {
    Object value = get(_key );
    if( value==null || !(value instanceof Boolean)) return _default_value;
    return ((Boolean)value).booleanValue();    
   }
   
   /**
    * Specialized get method for a byte property.
    * @return _default_value if key is unknown, null value is store or key is not 
    * associated with an instance of Number.
    */
   public final byte get(String _key, byte _default_value) 
   {
    Object value = get(_key );
    if( value instanceof Number ) return ((Number)value).byteValue();
    return _default_value;    
   }
   
   /**
    * Specialized get method for a short property.
    * @return _default_value if key is unknown, null value is store or key is not 
    * associated with an instance of Number.
    */
   public final short get(String _key, short _default_value) 
   {
    Object value = get(_key );
    if( value instanceof Number ) return ((Number )value).shortValue();
    return _default_value;    
   }
   
   /**
    * Specialized get method for an int property.
    * @return _default_value if key is unknown, null value is store or key is not 
    * associated with an instance of Number.
    */
   public final int get(String _key, int _default_value) 
   {
    Object value = get(_key );
    if( value instanceof Number ) return ((Number)value).intValue();
    return _default_value;    
   }
   
   /**
    * Specialized get method for a long property.
    * @return _default_value if key is unknown, null value is store or key is not 
    * associated with an instance of Number.
    */
   public final long get(String _key, long _default_value) 
   {
    Object value = get(_key );
    if( value instanceof Number ) return ((Number)value).longValue();
    return _default_value;    
   }
   
   /**
    * Specialized get method for a float property.
    * @return _default_value if key is unknown, null value is store or key is not 
    * associated with an instance of Number.
    */
   public final float get(String _key, float _default_value) 
   {
    Object value = get(_key );  
    if( value instanceof Number ) return ((Number)value).floatValue();
    return _default_value;    
   }
   
   /**
    * Specialized get method for a double property.
    * @return _default_value if key is unknown, null value is store or key is not 
    * associated with an instance of Number.
    */
   public final double get(String _key, double _default_value) 
   {
    Object value = get(_key );
    if( value instanceof Number ) return ((Number)value).doubleValue();
    return _default_value;    
   }
   
   /**
    * Specialized get method for a string property.
    * @return _default_value if key is unknown, null value  or key is not 
    * associated with a String object value.
    */
   public final String get(String _key, String _default_value) 
   {
    Object value = get(_key );
    if( value instanceof String ) return ((String)value);
    return _default_value;    
   }
   
   /**
    * Returns all properties in the store in a java.util.Map object.
    */
   public Map elements() 
   {
      return properties_;    
   }
}
