/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DSection.java,v 1.3 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;


/**
 * The DSection is a part of a document. The section contains IDParagraphItem and
 * can have a DHeader and DFooter item. A document can have zero, one or more DSection.
 * DSection support alignment,all the items added to the section will be displayed 
 * by the driver in the specified alignment. 
 * 
 * @see DHeader
 * @see DFooter
 * @see IDAlignment
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DSection extends DAbstractParagraph implements IDTaggedItem 
{
   private String tag ;
   public DHeader header;
   public DFooter footer;
   
   /**
    * Creates an empty section with tag _tag and an alignment.
    * This section contains no header and footer.
    * @see IDAlignment
    */
   public DSection(String _tag, int align) 
   {
   	super(align);
   	setTag( _tag );
   }
   
   /**
    * Creates an empty section with no tag and an alignment. 
    * By default the section is named 'sectiondef'
    * This section contains no header and footer.
    * 
    * @see IDAlignment
    */
   public DSection(int align) 
   {
   	super(align);
   	setTag(null);
   }
   
   /**
    * Creates an empty section with tag _tag.
    * This section contains no header and footer.
    */
   public DSection(String _tag) 
   {
   	 super();
     setTag( _tag );
   }
   
   /**
    * Creates an empty section with no tag. 
    * By default the section is named 'sectiondef'
    * This section contains no header and footer.
    */
   public DSection() 
   {
   	 super();
     setTag(null);
   }
   
   /**
    * Access method for the tag property.
    * 
    * @return   the current value of the tag property
    */
   public java.lang.String getTag() 
   {
    return tag;    
   }
   
   /**
    * Sets the value of the tag property. If aTag is null the section is tagged 
    * automatically 'sectiondef'
    * 
    * @param aTag the new value of the tag property
    */
   public void setTag(java.lang.String aTag) 
   {
      tag = aTag==null ? "sectiondef" : aTag ;  //$NON-NLS-1$  
   }
   
   /**
    * Access method for the header property.
    * 
    * @return   the current value of the header property
    */
   public DHeader getHeader() 
   {
      return header;    
   }
   
   /**
    * Sets the value of the header property.
    * 
    * @param aHeader the new value of the header property
    */
   public void setHeader(DHeader aHeader) 
   {
      header = aHeader;    
   }
   
   /**
    * Access method for the footer property.
    * 
    * @return   the current value of the footer property
    */
   public DFooter getFooter() 
   {
      return footer;    
   }
   
   /**
    * Sets the value of the footer property.
    * 
    * @param aFooter the new value of the footer property
    */
   public void setFooter(DFooter aFooter) 
   {
      footer = aFooter;    
   }
   
}
