/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DStyleRegistry.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * A style registry is a collection of IDStyle, the registry assures that a style 
 * is stored only once (in the meaning of '==').
 * 
 * @see IDStyle
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DStyleRegistry implements IDRegistry
{
   private ArrayList styles;
   
   /**
    * Creates an empty DStyleRegistry.
    */
   public DStyleRegistry() 
   {
      styles = new ArrayList();
   }
   
   
   /**
    * Clears the registry. All IDStyle object are removed.
    */
   public void clear() 
   {
      styles.clear();    
   }
   
   /**
    * Puts the style in the registry only if style isn't already stored.
    * (the null styles aren't stored).
    * @param style the style to store in registry.
    * @return stored style or null if storage is not done.
    */
   public IDStyle putStyle(IDStyle style) 
   {
     if( style==null ) return null;
     if( contains(style) ) return style;   
	 if( styles.add( style ) ) return style;
     return null;
   }
   
   /**
    * Merges the styles of the registry r with the current registry.
    * Only new styles are added in the current registry.
    * @param r the registry to merge.
    */
   public void merge(DStyleRegistry r) 
   {
   	if( r==null ) return;
   	
   	Iterator i = r.iterator();
   	while (i.hasNext())
   	{
   		Object s = i.next();
   		if (s instanceof IDStyle)
   			putStyle((IDStyle)s);
   	}
   }
   
   /**
    * Checks if the style already exists in the registry.
    * @return true if this registry contains given style.
    */
   public boolean contains( IDStyle style )
   {
     //compare object in strict way to do trust equals()
     for( Iterator it=styles.iterator(); it.hasNext(); )
     {
       if( it.next() == style ) return true;
     }
     return false;
   }
   
   /**
    * Returns an iterator to acces to all values in this registry.
    */
   public Iterator iterator() 
   {
      return styles.listIterator();
   }
   
   /**
    * Returns all IDStyle stored in the registry and they have the name _name 
    * in a java.util.List. This list can be empty if no IDStyle stored in the
    * registry has the name _name.
    * @see java.util.List
    */
   public List getStyles( String _name ) 
   {
      ArrayList list = new ArrayList();
      for( Iterator it = styles.iterator(); it.hasNext(); )
      {
         IDStyle sty = (IDStyle)it.next();
         if( sty.getName() == _name || _name!=null && _name.equals( sty.getName()) )
         {
           list.add( sty );
         }
      }
    
      return list;
   }

   /**
    * Returns the first style of the registry which have the name _name. If no style
    * has the name _name this method returns null.
    * @see #getStyles
    */
   public IDStyle getFirstStyle( String _name ) 
   {
      for( Iterator it = styles.iterator(); it.hasNext(); )
      {
         IDStyle sty = (IDStyle)it.next();
         if( sty.getName() == _name || _name!=null && _name.equals( sty.getName()) )
         {
           return sty;
         }
      }
      return null;
   }
   
   
   /**
    * Merges the styles which are existing in the registry with the styles which are
    * existing in the document doc.
    * Only not existing style are added in the current registry 
    */
   public void merge(IDItem root)
   {
      IDItemIterator iter = root.getIterator();
      IDItem item = iter.getFirst();
   
      while(item != null)
      {
   	     IDStyle idstyle = item.getStyle();
   	     if (idstyle != null)
   		    putStyle(idstyle);
   	    item = iter.getNext();
      }
   }
   
   /** @return true if registry is empty, false if not */
   public boolean isEmpty()
   {
     return styles.isEmpty();
   }
}
