/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DSummary.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;


/**
 * A DSummary is a table of contents which lists titles, title levels.
 * This item is not actually implemented by the drivers.
 * It will be implemented in the next version. 
 * <br><br>
 * @see DTitle
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DSummary extends DItem implements IDParagraphItem, IDTaggedItem 
{
   private int titleLevel = -1;
   private String tag;
   
   /**
    * Creates a Summary the for the title level between 0 and _maxLevel.
    * For all title levels the maxLevel can be equal to -1
    */
   public DSummary(int _maxLevel) 
   {
      titleLevel = _maxLevel;
   }
   
   /**
    * Creates a DSummary for all titles.
    */
   public DSummary() 
   {}
   
   /**
    * Access method for the titleLevel property.
    * 
    * @return   the current value of the titleLevel property
    */
   public int getTitleLevel() 
   {
      return titleLevel;    
   }
   
   /**
    * Sets the value of the titleLevel property.
    * 
    * @param aTitleLevel the new value of the titleLevel property
    */
   public void setTitleLevel(int aTitleLevel) 
   {
      titleLevel = aTitleLevel;    
   }
   
   /**
    * Access method for the tag property.
    * 
    * @return   the current value of the tag property
    */
   public java.lang.String getTag() 
   {
      return tag;    
   }
   
   /**
    * Sets the value of the tag property.
    * 
    * @param aTag the new value of the tag property
    */
   public void setTag(java.lang.String aTag) 
   {
      tag = aTag;    
   }
}
