/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DTable.java,v 1.2 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;


/**
 * A table is defined by rows and cells: it contains rows and each row contains 
 * cells. <br>
 * <br>
 * Exemple:<br>
 * DTable tab = new DTable(1,false);<br>
 * DRow r[2];<br>
 * r[0]=new DRow();<br>
 * r[1]=new DRow();<br>
 * DCell c1 = new DCell(), c2= new DCell();<br>
 * r[0].addChild(c1);<br>
 * r[0].insertChild(c2, c1);<br>
 * c1.addChild(new DText("cell 0,0"));<br>
 * c2.addChild(new DText("cell 0,1"));<br>
 * c1 = new DCell();<br>
 * c2 = new DCell();<br>
 * r[1].addChild(c1);<br>
 * r[1].insertChild(c2, c1);<br>
 * c1.addChild(new DText("cell 1,0"));<br>
 * c2.addChild(new DText("cell 1,1"));<br>
 * 
 * <br>
 * This exemple creates a table with 2 rows and 2 cells:<br>
 * _______________<br>
 * | cell 0,0   |	cell 0,1 |<br>
 * |______________ |<br>
 * | cell 1,0   |	cell 1,1 |<br>
 * |______________ |<br>
 * <br>
 * By default each column has the same size. You can set a width restriction for 
 * each by using the method setColumnWidth of the DTable. This method has one 
 * parameter that is a float table. For each column you can set a float value that 
 * indicates the percent size of the column of the document's width.<br>
 * <br>
 * Exemple:<br>
 * float cols[2]={0.25,0.75};<br>
 * tab.setColumnWidth(cols);<br>
 * <br>
 * Result:  <br>
 * 25.0 and 75.0 values represent respectively 25% for the first column and 75% 
 * for the second.<br>
 * ________________________________<br>
 * | cell 0,0 .. |	cell 0,1................................|<br>
 * |_______________________________|<br>
 * | cell 1,0 .. |	cell 1,1 ...............................|<br>
 * |_______________________________|<br>
 * 
 * 
 * 
 * @see DRow
 * @see DCell
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */

public class DTable extends DItemContainer implements IDSizeableItem, IDParagraphItem 
{
   private int border = 1;
   private float widthScale = 1.0f;
   private float heightScale = 1.0f;
   private float[] columnWidth = null;
   
   /**
    * Creates a DTable with border line size of 'b' pixels and a size policy or not.
    * 
    * @param b size of the border line
    */
   public DTable(int b) 
   {
      border = b;
   }
   
   /**
    * Creates a DTable.
     */
   public DTable() 
   {
    
   }
   
   /**
    * Access method for the border property.
    * 
    * @return   the current value of the border property
    */
   public int getBorder() 
   {
      return border;    
   }
   
   /**
    * Sets the value of the border property.
    * 
    * @param aBorder the new value of the border property
    */
   public void setBorder(int aBorder) 
   {
      border = aBorder;    
   }
   
   /**
    * Access method for the widthScale property.
    * 
    * @return   the current value of the widthScale property
    */
   public float getWidthScale() 
   {
    return widthScale;    
   }
   
   /**
    * Sets the value of the widthScale property.
    * 
    * @param aWidthScale the new value of the widthScale property
    */
   public void setWidthScale(float aWidthScale) 
   {
      widthScale = aWidthScale;    
   }
   
   /**
    * Access method for the heightScale property.
    * 
    * @return   the current value of the heightScale property
    */
   public float getHeightScale() 
   {
    return heightScale;    
   }
   
   /**
    * Sets the value of the heightScale property.
    * 
    * @param aHeightScale the new value of the heightScale property
    */
   public void setHeightScale(float aHeightScale) 
   {
      heightScale = aHeightScale;    
   }
   
   /**
    * Access method for the columnWidth property.
    * 
    * @return   the current value of the columnWidth property
    */
   public float[] getColumnWidth() 
   {
    return columnWidth;
   }
   
   /**
    * Sets the value of the columnWidth property.
    * 
    * @param aColumnWidth the new value of the columnWidth property
    */
   public void setColumnWidth(float[] aColumnWidth) 
   {
      columnWidth = aColumnWidth;    
   }
   
   /**
    * Returns the real number of columns.
    */
   public int getColumnCount() 
   {
   	  DRow r = null;
   	  int maxc = 0;
   	  for (r = (DRow)getFirstChild(); r != null; r = (DRow)r.getNext())
   	  {
   	  	 int cpt = r.getCellCount();
   	  	 if (cpt>maxc)
   	  	    maxc = cpt;
   	  }
      return maxc;    
   }
   
   /**
    * Returns the real number of lines.
    */
   public int getRowCount() 
   {
    return (getChildCount());    
   }
   
}
