/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DTag.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;


/**
 * A DTag is a fixed point in a document that represents a target for a link.
 * It is like an anchor in the document.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DTag extends DItem implements IDTaggedItem, IDParagraphItem 
{
   private String tag;
   
   /**
    * Creates a DTag named 'n'. 
    */
   public DTag(String tag) 
   {
     setTag( tag );
   }
   
   /**
    * Creates a DTag with no tag.By default this tagged  'tagdefault'
    */
   public DTag() 
   {
     setTag(null);
   }
   
   /**
    * Access method for the tag property.
    * 
    * @return   the current value of the tag property
    */
   public String getTag() 
   {
    return tag;    
   }
   
   /**
    * Sets the value of the tag property. If aTag is null the tag takes
    * 'tagdefault' automatically.
    * 
    * @param aTag the new value of the tag property
    */
   public void setTag(String aTag) 
   {
      tag = aTag==null ? "tagdefault" : aTag ;    
   }
}
