/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DTimeStamp.java,v 1.2 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;

/**
 * This interface provides the properties for the time stamp
 * information.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DTimeStamp extends DItem {
    
    private String  datePattern;
    private boolean show = true;
    private String  prefix;
    private String  value;
     
    /** creates a new time stamp object with no date format, 
     * show property setted at true and no prefix string label.
     */
    public DTimeStamp() {}
    
    /** creates a new time stamp object with a date format pattern, 
     * show property and label string prefix.
     */
    public DTimeStamp(String dateFormatPattern, boolean show, String prefix)
    {
        this.datePattern = dateFormatPattern;
        this.show = show;
        this.prefix = prefix;
    }
    
    /** @return the date format pattern*/
    public String getDatePattern() {
        return this.datePattern;
    }
    
    /** Sets the date format pattern */
    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }
    
    /** @return the label prefix string of the date */
    public String getPrefix() {
        return prefix;
    }
    
    /** sets the label prefix string of the date */
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
    
    /** @return true if the time stamp should be displayed */
    public boolean isShow() {
        return show;
    }
    
    /** sets the showing property for the time stamp */
    public void setShow(boolean show) {
        this.show = show;
    }
    
    /** @return the date value for the time stamp */
    public String getValue() {
        return value;
    }
    
    /** sets the date value for the time stamp */
    public void setValue(String value) {
        this.value = value;
    }
}
