/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DTitle.java,v 1.2 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;


/**
 * A DTitle is a title with a title level and a tag. 
 * The tag is usefull for the summary links. 
 * 
 * @see DSummary
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DTitle extends DItemContainer implements IDParagraphItem, IDTaggedItem 
{
   private int level;
   private String tag;
   
   /**
    * Creates a title with level 'l'.
    */
   public DTitle(int l) 
   {
      level = l;    
   }
   
   /**
    * Creates a title with a level equal to 0 and a null tag.
    */
   public DTitle() 
   {
     level=0;
     //tag not required.
   }
   
   /**
    * Access method for the level property.
    * 
    * @return   the current value of the level property
    */
   public int getLevel() 
   {
      return level;    
   }
   
   /**
    * Sets the value of the level property.
    * 
    * @param aLevel the new value of the level property
    */
   public void setLevel(int aLevel) 
   {
      level = aLevel;    
   }
   
   /**
    * @return  the current value of title's tag, might be null is no tag set.
    */
   public String getTag() 
   {
    return tag;    
   }
   
   /**
    * Sets the value of the tag associated with this title, might be null.    * 
    * @param aTag the new value of the tag.
    */
   public void setTag(String aTag) 
   {
      tag = aTag; //tag not required, might be null
   }
   
}
