/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DWallpaper.java,v 1.3 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 8 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.core.internal;


/**
 * IDWallpaper implementation.
 * Define a background image using various effect as position,repeat, scale...
 * Those effect can be used (by a driver) to render image in a rectangle.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DWallpaper implements IDWallpaper, IDObject
{
  /** place image in the center horizontally (this is the default, if nor LEFT neither RIGHT is used) */
  public static int HCENTER = 0x001;
  /** place image in the center vertically (this is the default, if nor TOP neither BOTTOM is used) */
  public static int VCENTER = 0x002;
  /** place the image on the left side of rendering rectangle */
  public static int LEFT    = 0x004;
  /** place the image on the right side of rendering rectangle */
  public static int RIGHT   = 0x008;
  /** the image is extended/reduced to fit the rectangle width.
   * if HREPEAT is used with, an integer number of image is used (ie the image can be scaled)
   */
  public static int HSCALE  = 0x010;
  /** place the image at the top of rendering rectangle */
  public static int TOP     = 0x020;
  /** place the image at the bottom of the rendering rectangle */
  public static int BOTTOM  = 0x040;
  /** same as HSCALE for rectangle height */
  public static int VSCALE  = 0x080;
  /** repeat image horizontally to fit rectnagle width. left, right or hscale can be used with hrepeat */
  public static int HREPEAT = 0x100;
  /** same as HREPEAT for rectangle height */
  public static int VREPEAT = 0x200;
  /** override any other effect, the image is drawn repeatly in the inside of rectangle */
  public static int BORDER  = 0x400;

  /** last valid effect value */
  public static int LAST = BORDER;

  /** combined mask */
  public static int  CENTER = HCENTER|VCENTER;
  public static int   SCALE = HSCALE|VSCALE;
  public static int  REPEAT = HREPEAT|VREPEAT;
  public static int  DEFAULT= CENTER;

  /** name of the image resource of the wallpaper*/
  private String image_name;
  /** effect applyed on the wallpaper image */
  private int    effect;
  
  /**
   * Create a wallpaper using default effect.
   */
  public DWallpaper( String name )
  {
    image_name = name;
    effect = CENTER;
  }
  
  /**
   * Create a wallpaper using given image and effect.
   * Effect is a or'ed (|) mask using one of effect defined (LEFT,TOP,...)
   */
  public DWallpaper( String name, int effect )
  {
    image_name = name;
    this.effect = effect;
  }
  
  /**
   * @return current image name of the wallpaper
   */
  public  String getName()
  {
    return image_name;
  }
  
  /**
   * Change the image name of the wallpaper.
   */
  public void setName( String name )
  {
    this.image_name = name;
  }
  
  /**
   * @return current effect value.
   */
  public int getEffect()
  {
    return effect;
  }
  
  /**
   * Change effect value of wallpaper.
   */
  public void setEffect( int effect )
  {
    this.effect = effect;
  }
  
  /**
   * @return true if effect have all the given effect mask.
   */
  public boolean isEffect( int mask )
  {
    return (effect&mask)==mask;
  }
  /**
   * @return true if effect have at least one of the effect in given mask.
   */
  public boolean haveEffect( int mask )
  {
    return (effect&mask)!=0;
  }

  /**
   * @return true if effect have all the effect set in mask.
   */
  public static boolean IsEffect( int effect, int mask )
  {
    return (effect&mask)==mask;
  }
  
  /**
   * @return true if effect have one (or more) effect in the given mask.
   */
  public static boolean HaveEffect( int effect, int mask )
  {
    return (effect&mask)!=0;
  }
  
  /** private usage, name of effect, must be in the same order as effect's bit */
  private static String name[] 
  = { "HCENTER", "VCENTER", "LEFT", "RIGHT", "HSCALE", "TOP", "BOTTOM",
      "VSCALE", "HREPEAT", "VREPEAT", "BORDER" };
      
  /**
   * @return string representation from effect, use name and '|' character.
   */
  public static String ToString( int effect )
  {
    String s = null;
    for( int e=1, bit=0; e<=LAST; e<<=1, bit++)
    {
      if( HaveEffect(effect, e))
      {
        if( s!=null ) s+="|" + name[bit]; else s = name[bit];
      }
    }
    return s;
  }
  
  /**
   * @return effect parsed in given string (used effect name and '|'.
   */
  public static int ToEffect( String str )
  {
    if(str==null) return DEFAULT;
    String s[] = str.split("\\|");
    if( s==null || s.length==0 ) return DEFAULT;
    int effect = 0;
    for( int i=0; i < s.length; ++i )
    {
      String n = s[i];
      for( int bit=0; bit<name.length; bit++ )
      {
        if( n.equals( name[i] ))
        {
          effect |= (1<<bit);
          break;
        }
      }
    }
    return effect;
  }
  
  /**
   * return string with wallpaper configuration
   */
  public String serializeToString()
  {
    String s = Integer.toString(effect,16) + ":" + image_name;
    return s;
  }
  
  /**
   * Reset wallpaper to default, and try to configure from speficied string.
   */
  public void serializeFromString( String str )
  {
    effect = DEFAULT;
    image_name=null;
    if( str==null ) return ; 
 
    int idx = str.indexOf(':');
    if( idx < 0 ) return ; //what's this string ? (must have ':')
    try{
      effect = Integer.parseInt( str.substring(0,idx), 16 );
    }
    catch( NumberFormatException e ) {}
    image_name = str.substring( idx+1 );
  }
}
