/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDAlignment.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 3 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.core.internal;

/**
 * Provides an interface for alignment/style definitions, that can be combined each others.
 * Aligments are defined by bit field (and mask), and can be or'ed using '|' operator.
 * Object where alignment is applied may choose to not take into account of all alignment
 * defined.
 * 
 * @see DParagraph
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IDAlignment
{
  /** define left alignment */
  public static final int LEFT    = 0x0001;
  /** define right alignment*/
  public static final int RIGHT   = 0x0002;
  /** define horizontally centered alignment*/
  public static final int HCENTER = 0x0004;
  /** define top alignment */
  public static final int TOP     = 0x0008;
  /** define bottom alignment */
  public static final int BOTTOM  = 0x0010;
  /** define vertically centered alignment */
  public static final int VCENTER = 0x0020; 
  /** vertical, can means top to bottom. */
  public static final int VERTICAL= 0x0040;
  /** 90 degree counter clockwise alignment */
  public static final int ROTCCW90= 0x0080;
  /** 90 degree clockwise alignment */
  public static final int ROTCW90 = 0x0100;

  /** define last bit field value */
  public static final int LAST   = ROTCW90;
  
  /** define both horiz/verti centered alignment (not a bit definition) */
  public static final int CENTER  = 0x0024;
    
  /** Define default alignment */
  public static final int DEFAULT_ALIGN = TOP|LEFT;
  
  /** No Word Wrap mode for the paragraph */
  public static final int NO_WORD_WRAP = 0x0100;

  /**
   * @return current alignment (full combined mask ).
   */
  public int  getAlignment();

  /**
   * @return current alignment reduced to given mask.
   */
  public int  getAlignment( int _alignment_mask );

  /** 
   * Change alignment to the given value.
   */  
  public void setAlignment( int _alignments );
  /**
   * Add alignment mask to current alignment.
   */
  public void addAlignment( int _alignments );
  
  /**
   * Remove alignment mask from current alignment.
   */
  public void removeAlignment( int _alignments );
  
  /**
   * @return true if current value of alignement contains <b>all</b> alignment defined in parameter,
   * but current value might contains more alignment.
   * for example if current value is LEFT|TOP|VERTICAL, haveAlignment(LEFT) will return true,
   * but haveAlignment(LEFT|BOTTOM) will return false;
   */
  public boolean haveAlignment( int _alignment_mask );
  
  /**
   * @return true if current value of alignement contains <b>one of</b> alignment defined in parameter,
   * but current value might contains more alignment.
   * for example if current value is LEFT|TOP|VERTICAL, haveOneOfAlignment(LEFT) will return true,
   * but haveOneOfAlignment(LEFT|BOTTOM) will return true too;
   */
  public boolean haveOneOfAlignment( int _alignment_mask );
}
