/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDColor.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;



/**
 * Provides an interface for the color object in JScrib document. The colors are
 * described with the RGB codage. Each color component is implemented with an 
 * integer. For a compatibily with {@link org.eclipse.swt.SWT} just the values between 0-255 are 
 * used. If you don't use SWT you can implement you Color object on the entire 
 * integer range.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IDColor extends IDObject, IDStringSerializable
{
   
   /**
    * Returns red value.
   */
   public int getRed();
   
   /**
    * Returns green value.
    */
   public int getGreen();
   
   /**
    * Returns blue value.
    */
   public int getBlue();
   
   /**
    * Sets the red value to 'r'.
    */
   public void setRed(int r);
   
   /**
    * Sets the green value to 'g'.
    */
   public void setGreen(int g);
   
   /**
    * Sets the blue value to 'b'.
    */
   public void setBlue(int b);
   
   /**
    * Sets the RGB value.
    * 
    * @param r red value
    * @param g green value
    * @param b blue value
    */
   public void setRGB(int r, int g, int b);
   
   /**
    * @return the unique id of the color.
    */
   public String getID();

}
