/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDCoord.java,v 1.2 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 7 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.core.internal;

/**
 * Defines minimal requirement a coordinate on a axis have to provide.
 * @see DAxis 
 * @see DCoord
 * @see DCoordObject
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IDCoord
{
  /** 
   * @return axis from which this coordinate belongs, must not be null.
   */
  public DAxis getAxis();
  
  /**
   * @return the value stored in this coordinate. if parameter is a suitable instance,
   * implementor can choose to reuse this instance rather than allocate another object.
   */
  public Object getValue( Object _param );

  /**
   * Change the current value of coordinate.
   * Do nothing if _value's class isn't known (can't be handled) by IDCoord. 
   */
  public void setValue( Object _value );
  
  /**
   * Change the current axis this coordinate belongs to.
   */
  public void setAxis( DAxis axis );
}
