/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDFont.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;



/**
 * Provides an interface for the Font object in JScrib documents. A font is 
 * defined with its family and script. Script is the charset code that the 
 * font uses in the all font characters (ex: latin1). An IDFont has a size
 * in pixel and a style. The style is a combination of followings values:
 * <ul>
 * <li>NORMAL: default font style
 * <li>BOLD: <b>bold style</b>
 * <li>ITALIC: <i>italic style</i>
 * <li>UNDERLINE: a line below text
 * <li>OVERLINE: a line above text
 * <li>DASHED: a dashed line below text
 * <li>STRIKE: a line over text
 * </ul> 
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IDFont extends IDObject
{
   /** define NORMAL font style */
   public static final int NORMAL = 0x00;

   /** define BOLD font style */
   public static final int BOLD =  0x01;
   
   /** define ITALIC font style */
   public static final int ITALIC = 0x02;
   
   /** define UNDERLINE font style (a line below text) */
   public static final int UNDERLINE = 0x04;
   
   /** define OVERLINE font style (a line above text) */
   public static final int OVERLINE = 0x08;

   /** define DASHED font style (a dashed line below text) */
   public static final int DASHED = 0x10;
   
   /** define STRIKE font style (a line over text) */
   public static final int STRIKE = 0x20;
   
   /** Mask for properties style "lines". This is not a font style */
   public static final int LINE_STYLES = UNDERLINE|DASHED|OVERLINE|STRIKE;
   
   /**
    * Returns if the font family.
    */
   public String getFamily();
   
   /**
    * Returns if the font script name.
    */
   public String getScript();
   
   /**
    * Returns the font size.
    */
   public int getSize();
   
   /**
	* Returns the font style.
	*/
   public int getStyle();
   
   /**
    * Sets the font family to 'f'.
    * 
    * @param f font family parameter
    */
   public void setFamily(String f);
   
   /**
    * Sets the font script name to 's'.
    * 
    * @param s font script name
    */
   public void setScript(String s);
   
   /**
    * Sets the font size to 's'.
    * 
    * @param s font size
    */
   public void setSize(int s);

   /**
    * Set the font style.
    * 
    * @param style new font style
    */
   public void setStyle(int style);   
   
   /**
    * Checks if the font has the style _style
    * @return true if font style is exactly the style given in parameter.
    * If font style is BOLD|ITALIC, then haveStyle(BOLD) return false, and haveStyle(BOLD|ITALIC) return true;
    */
   public boolean isStyle(int _style);
   
   /**
    * Checks if the font has one or more style item of _style
    * @return true if font style have one (or more) style given in parameter.
    * If font style is BOLD|ITALIC, then haveStyle(BOLD) return true, and haveStyle(BOLD|ITALIC) return true
    */
   public boolean haveStyle(int _style);
   
   /**
    * @return the unique id of the font.
    */
   public String getID();

}
