/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDItem.java,v 1.3 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/




package org.eclipse.tptp.platform.report.core.internal;



/**
 * Provides an interface for all items in a JScrib document except
 * Colors, Fonts and Styles.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IDItem extends IDObject
{
   
   /**
    * Adds a child item after the last child.
    */
   public boolean addChild(IDItem item);
   
   /**
    * Clears the resources kept by the item.
    */
   public void clear();
   
   /**
    * Returns the item child number.
    */
   public int getChildCount();
   
   /**
    * Returns the child item position in the list.
    */
   public int getChildPosition(IDItem i);
   
   /**
    * Returns the current document.
    */
   public IDItem getRoot();
   
   /**
    * Returns the first child of the item.
    */
   public IDItem getFirstChild();
   
   /**
    * Returns the item iterator.
    */
   public IDItemIterator getIterator();
   
   /**
    * Returns the last child of the item.
    */
   public IDItem getLastChild();
   
   /**
    * Returns the next item.
    */
   public IDItem getNext();
   
   /**
    * Returns the parent of the item.
    */
   public IDItem getParent();
   
   /**
    * Returns the style to applied on this item, might be getStyle() or one of parent's 
    * style if getStyle returns null.
    * 
    * @see #getStyle
    */
   public IDStyle getAppliedStyle();
   
   /**
	* Returns the item style.
	*/
   public IDStyle getStyle();

   /**
    * Inserts the child 'item' after the item 'after' if acceptChild(item,after) 
    * returns true. 
    * 
    * @param child child to be attached
    * @param after item after which child should be added
    */
   public boolean insertChild(IDItem item, IDItem after);
   
   /**
    * Returns true if the item is a container.
    */
   public boolean isContainer();
   
   /**
    * Removes the child 'item'.
    */
   public boolean removeChild(IDItem item);
   
   /**
    * Sets the next item to 'i'.
    * 
    * @param i next item
    */
   public void setNext(IDItem i);
   
   /**
    * Sets the parent item to 'p'.
    * 
    * @param p parent item
    */
   public void setParent(IDItem p);
   
   /**
    * Sets the item style to 'style'.
    * 
    * @param style item style
    */
   public void setStyle(IDStyle style);
}
