/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDItemIterator.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;



/**
 * Provides an interface to parse a IDItem hierarchy. Before parsing item
 * with an IDItemIterator you should call getFirst to take the first item
 * and getNext to take the next item. The method getNext returns null if 
 * there is no next item to parse (ie: getNext()==getFirst()).<br>
 * 
 * <pre>
 * //usage example 1 
 * for (IDItem c = iterator.getFirst(); c != null; c = c.getNext())
 * {
 * ...
 * }
 * 
 * //usage example 2
 * iterator.getFirst()
 * while (iterator.getCurrent()!=null)
 * {
 *     ...
 *     getNext();
 * }
 * 
 * </pre>
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IDItemIterator extends IDObject
{
   
   /**
    * Returns the current item pointed by the iterator.
    * Returns null if the iterator is at the end.
    */
   public IDItem getCurrent();
   
   /**
    * Returns the first IDItem the iterator of the first child.
    */
   public IDItem getFirst();
   
   /**
    * Returns the iterator of the last child.
    */
   public IDItem getLast();
   
   /**
    * Returns the iterator of the next item.
    */
   public IDItem getNext();
   
   /**
    * Sets the current item to 'i'.
    * 
    * @param i item to make current
     */
   public void setCurrent(IDItem i);
}

