/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDLink.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;


/**
 * An IDLink allows to define links in various node of a document.
 * An IDLink describes a link to a document, a section and a tag. The target is 
 * described as a string where optional method identifier is separate from path using
 * a colon: (method ':')? (path)
 * path is build using '/' separator.
 * @see DLinkUtil utility class and DLink.
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public interface IDLink extends IDObject
{
   /**
    * Access for the target property.
    * @return   the current value of the target property
    */
   public String getTarget();
   
   /**
    * Sets target value of a link.
    */
   public void setTarget( String a_target );
   
   /**
    * Returns IDItem associated with this link, this is mandatory for link resolution purpose.
    * For an IDItem implementing IDLink, just return "this" is good.
    * @return IDItem associated with this link.
    */
   public IDItem getLinkedItem();
   
}

