/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDSizeableItem.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.core.internal;


/**
 * Provides an interface for resizable IDItem.
 * With this interface it is possible to apply constraint on an item
 * with a factor on Width and Height size.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IDSizeableItem extends IDItem 
{
   
   /**
    * Sets the height scale to 'v'.
    * 
    * @param v value of the height scale
    */
   public void setHeightScale(float v);
   
   /**
    * Sets the width scale to 'v'.
    * 
    * @param v value of the width scale
    */
   public void setWidthScale(float v);
   
   /**
    * Returns the value of the height scale.
    */
   public float getHeightScale();
   
   /**
    * Gets the value of the width scale.
    */
   public float getWidthScale();
}
