/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDStyle.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;



/**
 * Provides an interface the style in JScrib. A JScrib style is defined
 * with a name,a font, a background and foreground colors.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IDStyle extends IDObject
{
   
   /**
    * Returns the style font.
    */
   public IDFont getFont();
   
   /**
    * Sets the style font to 'f'.
    * 
    * @param f style font
    */
   public void setFont(IDFont f);
   
   /**
    * Sets the style foreground color to 'c'.
    * 
    * @param c style foreground color
    */
   public void setForeColor(IDColor c);
   
   /**
    * Returns the style foreground color.
    */
   public IDColor getForeColor();
   
   /**
    * Sets the style background color to 'c'.
    * 
    * @param c style background color
    */
   public void setBackColor(IDColor c);
   
   /**
    * Returns the style background color.
    */
   public IDColor getBackColor();
   
   /**
    * Sets the style name to 'n'.
    * 
    * @param n style name
    */
   public void setName(String n);
   
   /**
    * Returns the style name.
    */
   public String getName();
   
   /**
    * Sets the style format  to 'format'.
    * 
    * @param format style numbering format.
    */
   public void setNumberingFormat(int format);
   
   /**
    * Returns the style format.
    */
   public int getNumberingFormat();
   
   /**
    * Returns current wallpaper.
    */
   public IDWallpaper getWallpaper();
   
   /**
    * Changes current wallpaper.
    */
   public void setWallpaper( IDWallpaper wallpaper );
   
   /**
    * @return the unique id of the style.
    */
   public String getID();
}
