/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDocumentReader.java,v 1.2 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.core.internal;

import java.io.InputStream;

import org.w3c.dom.Document;


/**
 * IReader is provided to federate any class wanted to read IDObject, 
 * using an InputStream.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IDocumentReader {

	/**
	 * Reads the IDObject from an InputStream.
	 */
	public IDObject[] read(InputStream in);

	/**
	 * Reads the IDObject from an Document.
	 */
	public IDObject[] read(Document in);

	/**
	 * Get a list of document objects that were read in.
	 */
	public IDObject[] getDocuments();
	

	/**
	 * Get a list of style objects that were read in.
	 */
	public IDObject[] getStyles();	
}
