/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLGraphicReader.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/
/*
 * Created on Mar 3, 2005
 */
package org.eclipse.tptp.platform.report.core.internal;

import java.io.InputStream;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Document;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlDocumentReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IXmlParser;
import org.eclipse.tptp.platform.report.drivers.xml.internal.XSDXmlParserAdapter;

/**
 * XMLGraphicReader is a concrete class that will take in an xml document that
 * represents a chart and create an object model.  The xml document is provided 
 * via an input stream.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class XMLGraphicReader extends DXmlDocumentReader implements IDocumentReader {

	protected IDObject[] idObjects;
	protected IDObject[] documents;
	protected IDObject[] styles;
	
	public XMLGraphicReader(){
		this(new XSDXmlParserAdapter(new XSDParser()));
	}
	/**
	 * @param parser
	 */
	public XMLGraphicReader(IXmlParser parser) {
		super(parser);
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.core.IDocumentReader#read(org.w3c.dom.Document)
	 */
	public IDObject[] read(Document in) {
		idObjects = null;
		documents = null;
		styles    = null;
		try {
			idObjects =  super.read(in);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return idObjects;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.core.IDocumentReader#read(java.io.InputStream)
	 */
	public IDObject[] read(InputStream in) {
		idObjects = null;
		documents = null;
		styles    = null;
		try {
			idObjects =  super.read(in);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return idObjects;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.core.IDocumentReader#getDocuments()
	 */
	public IDObject[] getDocuments() 
	{
		if ((idObjects != null) && (documents  == null))
		{
			final int len = idObjects.length;
			int n_doc = 0;
			for (int i = 0; i<len; i++)
			{
				if (idObjects[i] instanceof DDocument) n_doc++;				
			}
			documents = new IDObject[n_doc];
			if( n_doc > 0 )			   
			for (int ir=0, iw=0 ; ir<len; ir++) {
				if (idObjects[ir] instanceof DDocument) {
					documents[iw++] = idObjects[ir];
				}
			}
		}
		return documents;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.core.IDocumentReader#getStyles()
	 */
	public IDObject[] getStyles()
	{
		if ((idObjects != null) && (styles  == null))
		{
		    final int len = idObjects.length; 
		    int n_styles = 0;
		    for (int i=0; i<len; i++)
		    {
				if (idObjects[i] instanceof DStyle) n_styles++;
			}
		    styles = new IDObject[n_styles];
		    if( n_styles>0 )
		    {
		        for (int ir=0, iw=0; ir<len; ir++ ) {
		            if (idObjects[ir] instanceof DStyle) {
		                styles[iw++] = idObjects[ir];
		            }
		        }
		    }
		}
		return styles;
	}

}
