/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IBounds.java,v 1.2 2005/06/08 16:16:06 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.report.core.provisional;

/**
 * Interface that specifies a width and height value.  IBounds objects are used to define the chart dimensions 
 * during generation time. 
 */
public interface IBounds {

	/**
	 * Returns the height of the bound.
	 * @return the height of the bound.
	 */
	public abstract double getHeight();

	/**
	 * Sets the height of the bound
	 * @param height the height of the bound
	 */
	public abstract void setHeight(double height);

	/**
	 * Returns the width of the bound.
	 * @return the width of the bound.
	 */
	public abstract double getWidth();

	/**
	 * Sets the width of the bound
	 * @param width the width of the bound
	 */
	public abstract void setWidth(double width);

}