/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRenderer.java,v 1.4 2005/06/16 18:34:46 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.report.core.provisional;

/**
 * An interface that defines apis needed by a device renderer to render a chart.
 */
public interface IRenderer {
	/**
	 * Property key that specifies the output stream used to generate a chart.  Note not all renderers
	 * may not support this property.
	 */
   public static final String OUTPUTSTREAM_IDENTIFIER = "tptp.output.stream";
   /**
    * This method provides the ability to set renderer specific parameters.   
    * @param key The parameter name.
    * @param value The value of the parameter.
    * @throws RendererException Throws an exception if the parameter is not supported by the renderer.
    */
   public void setProperty(String key, Object value) throws RendererException;
   /**
    * Renders a chart based on a chart model.
    * @param chart The chart model
    * @throws RendererException Throws an exception if an error occurs during rendering.
    */
   public void render(IChart chart) throws RendererException;
}
