/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRuntimeContext.java,v 1.5 2008/12/17 18:18:24 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.report.core.provisional;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;

/**
 * Provides runtime information needed by the Generator to render a chart.
 * Information such as locale, time zone and resource bundles.  Users would use 
 * this class to set internationalization information to the Generator.  Note that 
 * some renderers may not support internationalization. 
 *
 */
public interface IRuntimeContext {

	/**
	 * Returns the time zone of the runtime context.
	 * @return the time zone of the runtime context.
	 */
	public abstract TimeZone getTimeZone();

	/**
	 * Sets the time zone of the runtime context.
	 * @param timeZone
	 */
	public abstract void setTimeZone(TimeZone timeZone);

	/**
	 * Returns the locale of the runtime context.
	 * @return the locale of the runtime context.
	 */
	public abstract ULocale getLocale();

	/**
	 * Sets the locale of the runtime context.
	 * @param locale
	 */
	public abstract void setLocale(ULocale locale);

	/**
	 * Resource bundle that contains externalized strings.
	 * @return
	 */
	public abstract String getResourceBundle();

	/**
	 * Sets the resource bundle that contains externalized strings.
	 * @param resourceBundle
	 */
	public abstract void setResourceBundle(String resourceBundle);

}