/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISerializer.java,v 1.5 2005/06/16 18:34:46 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.core.provisional;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.w3c.dom.Document;

/**
 * This interface defines apis to load a chart model from an XML file or DOM based on the chart schema.  This 
 * interface also defines apis to write a chart model to an output stream.
 */

public interface ISerializer
{

    /**
     * Writes the chart model to the OutputStream provided.
     * 
     * @param model The model to be serialized 
     * @param os The OutputStream to which the model is to be serialized
     */
    public void write(IChart model, OutputStream os) throws IOException;

    
    /**
     * Reads the chart model from the InputStream.  The contents of the inputstream must conform to
     * the chart schema.
     * 
     * @param is InputStream that contains chart information.
     * 
     * @return chart Model read from the stream
     */
    public IChart read(InputStream is) throws IOException;

   /**
     * Reads the chart model from a DOM.  The contents of the DOM must conform to
     * the chart schema.
     * 
     * @param dom Document object model that contains chart information.
     * 
     * @return chart Model read from the DOM
     */
    public IChart read(Document dom) throws IOException;

    /**
     * Reads in an input stream that contains xml content and produces a DOM representation of the
     * content.
     * 
     * @param is InputStream that contains xml data.
     * 
     * @return DOM representation of the xml data.
     */
    public Document toDOM(InputStream is) throws IOException;    
}