/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RendererException.java,v 1.3 2005/06/16 18:34:46 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.report.core.provisional;
/**
 * This exception will be thrown if an error occurs during chart rendering time.
 */
public class RendererException extends Exception {

    static final long serialVersionUID = -2356310306448304470L;
	/**
	 * Constructs a RendererException with no specified detail message or cause.
	 */    
	public RendererException() {
		super();
	}

	/**
	 * Constructs a RendererException with the specified detail message and cause.
	 * @param cause the cause (which is saved for later retrieval by the Throwable.getCause() method). (A null value is permitted, and indicates that the cause is nonexistent or unknown.)
	 * @param message detailed error message.
	 */
	public RendererException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Constructs a RendererException with the specified detail message.
	 * @param message detailed error message.
	 */
	public RendererException(String message) {
		super(message);
	}

	/**
	 * Constructs a RendererException with a specified cause.
	 * @param cause the cause (which is saved for later retrieval by the Throwable.getCause() method). (A null value is permitted, and indicates that the cause is nonexistent or unknown.)
	 */
	public RendererException(Throwable cause) {
		super(cause);
	}

}
