/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RuntimeContextImpl.java,v 1.5 2008/12/17 18:18:23 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.report.core.provisional;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;

/**
 * Concrete class that implements the IRuntimeContext interface.
 * 
 * @see org.eclipse.tptp.platform.report.core.provisional.IRuntimeContext
 */
public class RuntimeContextImpl implements IRuntimeContext {
protected ULocale locale;
protected TimeZone timeZone;
protected String resourceBundle;

/* (non-Javadoc)
 * @see org.eclipse.tptp.platform.report.core.provisional.IRuntimeContext#getTimeZone()
 */
public TimeZone getTimeZone() {
	return timeZone;
}

/* (non-Javadoc)
 * @see org.eclipse.tptp.platform.report.core.provisional.IRuntimeContext#setTimeZone(java.util.TimeZone)
 */
public void setTimeZone(TimeZone timeZone) {
	this.timeZone = timeZone;
}

/* (non-Javadoc)
 * @see org.eclipse.tptp.platform.report.core.provisional.IRuntimeContext#getLocale()
 */
public ULocale getLocale() {
	return locale;
}

/* (non-Javadoc)
 * @see org.eclipse.tptp.platform.report.core.provisional.IRuntimeContext#setLocale(java.util.Locale)
 */
public void setLocale(ULocale locale) {
	this.locale = locale;
}

/* (non-Javadoc)
 * @see org.eclipse.tptp.platform.report.core.provisional.IRuntimeContext#getResourceBundle()
 */
public String getResourceBundle() {
	return resourceBundle;
}

/* (non-Javadoc)
 * @see org.eclipse.tptp.platform.report.core.provisional.IRuntimeContext#setResourceBundle(java.lang.String)
 */
public void setResourceBundle(String resourceBundle) {
	this.resourceBundle = resourceBundle;
}
}
