/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CursorUtil.java,v 1.2 2008/05/23 14:11:57 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 18 nov. 2003
 *
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

/**
 * Class for Cursor creation...
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class CursorUtil
{
  /** internal palette cache ... only N&B */  
  private static PaletteData pal_;


  /** 
   * Strings definition for cursor.
   * Cursor size is from size of string array (height), and length of first string (width).
   * All string must have same width.
   * Remeber that on few system, cursor must be 16x16 or 32x32
   * cursor pixel is from char:
   * 'n': black pixel
   * '.': white pixel
   * ' ': no pixel (transparency)
   *    : any other: xorput pixel
   * @param _str cursor image definition, see above
   * @param _hsx x hotspot for cursor @see Cursor
   * @param _hsy y hotspot for curosr @see Cursor
   */  
  public static Cursor CursorFromString( String[] _str, int _hsx, int _hsy )
  {
    if( pal_==null )
    {
      RGB rgb [] = { new RGB(0,0,0), new RGB(255,0,0) };
      pal_ = new PaletteData( rgb );
    }
    int w = _str[0].length();
    int h = _str.length;
    byte[] src = new byte[ w*h ];
    byte[] msk = new byte[ w*h ];
    int cb = 0;
    int mask=0x80;
    
    for( int y=0; y<_str.length; ++y )
    {
      int cw = _str[y].length();
      if( cw!=w)
      {
        System.err.println("Width mismatch in CursorFromString"); return null;
      } 
      for( int x=0; x<_str[y].length(); ++x )
      {
        char chr = _str[y].charAt(x);
        switch( chr )
        {
          case '.': //set src=0 msk=1
            msk[cb] |= mask;
            break;
          case 'n'://set src=0 msk=0
            break;
          case ' ': //set src=1 msk=0
            src[cb] |= mask;
            break;
          default://set src=1 msk=1
            msk[cb] |= mask; src[cb]|=mask;
            break;
        }
        mask = mask >>1;
        if( mask==0)
        {
          mask=0x80;
          cb++;
        }
      }
    }
    
    ImageData i_src = new ImageData( w,h,1, pal_, 1, src );
    ImageData i_msk = new ImageData( w,h,1, pal_, 1, msk );

    Cursor crs= new Cursor( null, i_src, i_msk, _hsx, _hsy );

    return crs;
  }

}
