/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DSymbolRegistry.java,v 1.2 2008/05/23 14:11:56 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drawutil.internal;


/**
 * A Canvas for a symbol registry, as for the moment their no way to extends/redefine (to be done),
 * only jscrib defined symbol can be used.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DSymbolRegistry //not:yet: implements IDRegistry
{
  private static ISymbol SQUARE;
  private static ISymbol OVAL,OVALDOT;
  private static ISymbol DIAMOND;
  private static ISymbol UP, DOWN, LEFT, RIGHT;
  private static ISymbol PLUS, MINUS;
  private static ISymbol MOONDN, MOONUP, MOONLF, MOONRG;
  private static ISymbol SQUARE2;
  private static ISymbol STAR, HEXA, PENTA, HEXACR, HEXACR2, CROSS, CROSS2, HTRI2, VTRI2;
  
  /**
   * @return default (core) symbol corresponding to given name. or null if unknown.
   */
  public static ISymbol GetCoreSymbol( String name )
  {
    if( name==null ) return null;
    if( name.equals( ISymbol.Square .class.getName() )) return GetSquare();
    if( name.equals( ISymbol.Oval   .class.getName() )) return GetOval();
    if( name.equals( ISymbol.OvalDot.class.getName() )) return GetOvalDot();
    if( name.equals( ISymbol.Up     .class.getName() )) return GetUp();
    if( name.equals( ISymbol.Down   .class.getName() )) return GetDown();
    if( name.equals( ISymbol.Left   .class.getName() )) return GetLeft();
    if( name.equals( ISymbol.Right  .class.getName() )) return GetRight();
    if( name.equals( ISymbol.Plus   .class.getName() )) return GetPlus();
    if( name.equals( ISymbol.Minus  .class.getName() )) return GetMinus();
    if( name.equals( ISymbol.Diamond.class.getName() )) return GetDiamond();
    if( name.equals( ISymbol.MoonDown .class.getName() )) return GetMoonDown();
    if( name.equals( ISymbol.MoonUp   .class.getName() )) return GetMoonUp();
    if( name.equals( ISymbol.MoonLeft .class.getName() )) return GetMoonLeft();
    if( name.equals( ISymbol.MoonRight.class.getName() )) return GetMoonRight();
    if( name.equals( ISymbol.Square2  .class.getName() )) return GetSquare2  ();
    if( name.equals( ISymbol.Star     .class.getName() )) return GetStar();
    if( name.equals( ISymbol.Pentagon .class.getName() )) return GetPentagon();
    if( name.equals( ISymbol.Hexagon  .class.getName() )) return GetHexagon();
    if( name.equals( ISymbol.HexagonCross.class.getName() )) return GetHexaCross();
    if( name.equals( ISymbol.HexagonCross2.class.getName() )) return GetHexaCross2();
    if( name.equals( ISymbol.Cross    .class.getName() )) return GetCross();
    if( name.equals( ISymbol.Cross2    .class.getName() )) return GetCross2();
    if( name.equals( ISymbol.HTri2    .class.getName() )) return GetHTri2();
    if( name.equals( ISymbol.VTri2    .class.getName() )) return GetVTri2();
    return null;
  }
  
  public static ISymbol GetSquare () { if( SQUARE == null ) SQUARE = new ISymbol.Square (); return SQUARE; } 
  public static ISymbol GetOval   () { if( OVAL   == null ) OVAL   = new ISymbol.Oval   (); return OVAL  ; }
  public static ISymbol GetOvalDot() { if( OVALDOT== null ) OVALDOT= new ISymbol.OvalDot(); return OVALDOT; }
  public static ISymbol GetUp     () { if( UP     == null ) UP     = new ISymbol.Up     (); return UP    ; }
  public static ISymbol GetDown   () { if( DOWN   == null ) DOWN   = new ISymbol.Down   (); return DOWN  ; }
  public static ISymbol GetLeft   () { if( LEFT   == null ) LEFT   = new ISymbol.Left   (); return LEFT  ; }
  public static ISymbol GetRight  () { if( RIGHT  == null ) RIGHT  = new ISymbol.Right  (); return RIGHT ; }
  public static ISymbol GetPlus   () { if( PLUS   == null ) PLUS   = new ISymbol.Plus   (); return PLUS  ; }
  public static ISymbol GetMinus  () { if( MINUS  == null ) MINUS  = new ISymbol.Minus  (); return MINUS ; }
  public static ISymbol GetDiamond() { if( DIAMOND== null ) DIAMOND= new ISymbol.Diamond(); return DIAMOND; }
  public static ISymbol GetMoonDown () { if( MOONDN == null ) MOONDN = new ISymbol.MoonDown (); return MOONDN; }
  public static ISymbol GetMoonUp   () { if( MOONUP == null ) MOONUP = new ISymbol.MoonUp   (); return MOONUP; }
  public static ISymbol GetMoonLeft () { if( MOONLF == null ) MOONLF = new ISymbol.MoonLeft (); return MOONLF; }
  public static ISymbol GetMoonRight() { if( MOONRG == null ) MOONRG = new ISymbol.MoonRight(); return MOONRG; }
  public static ISymbol GetSquare2  () { if( SQUARE2 == null ) SQUARE2 = new ISymbol.Square2 (); return SQUARE2; } 
  public static ISymbol GetStar     () { if( STAR  == null ) STAR  = new ISymbol.Star();     return STAR;  } 
  public static ISymbol GetPentagon () { if( PENTA == null ) PENTA = new ISymbol.Pentagon(); return PENTA; } 
  public static ISymbol GetHexagon  () { if( HEXA  == null ) HEXA  = new ISymbol.Hexagon();  return HEXA;  } 
  public static ISymbol GetHexaCross() { if( HEXACR== null ) HEXACR= new ISymbol.HexagonCross();  return HEXACR;  } 
  public static ISymbol GetHexaCross2() { if( HEXACR2== null ) HEXACR2= new ISymbol.HexagonCross2();  return HEXACR2;  } 
  public static ISymbol GetCross    () { if( CROSS == null ) CROSS = new ISymbol.Cross();  return CROSS;  } 
  public static ISymbol GetCross2   () { if( CROSS2== null ) CROSS2 = new ISymbol.Cross2();  return CROSS2;  } 
  public static ISymbol GetHTri2    () { if( HTRI2 == null ) HTRI2 = new ISymbol.HTri2();  return HTRI2;  } 
  public static ISymbol GetVTri2    () { if( VTRI2 == null ) VTRI2 = new ISymbol.VTri2();  return VTRI2;  } 
  
  /**
   * @return name use for that symbol.
   */
  public static String GetCoreSymbolName( ISymbol sym )
  {
    if( sym==null) return null;
    return sym.getClass().getName();
  }

}
