/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HSV.java,v 1.2 2008/05/23 14:11:56 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 7 juil. 2003
 *
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

/**
 * HSV is a variant of space color that differ from RGB one.
 * Note: this class must not depends on any SWT classes or packages, if you need this,
 * take a look at HSVSWT class.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class HSV
{
  protected int h_,s_,v_;
  
  public HSV( int _r, int _g, int _b )
  {
    setRGB( _r, _g, _b );
  }
  public HSV( int _rgba )
  {
    setRGB( RGBA.GetR(_rgba), RGBA.GetG(_rgba), RGBA.GetB(_rgba) );
  }
  
  public int getH() { return h_; }
  public int getS() { return s_; }
  public int getV() { return v_; }
  
  
  public void setRGB( int _r, int _g, int _b )
  {
    int xc = _r;      // maximum r,g,b component value
    int xc_is = 0;    // r:0, g:1, b:2
    if ( _g > xc ) { xc = _g; xc_is = 1; }
    if ( _b > xc ) { xc = _b; xc_is = 2; }
    
    int nc = (int)Math.min( _r, Math.min( _r, _g ));

    int diff = xc-nc;
    v_ = xc;         // calc value
    s_ = xc==0 ? 0 : (510*diff+xc)/(2*xc);
    if ( s_ == 0 ) {
        h_ = -1;        // undefined hue
    }
    else
    {
      int diff2 = diff<<1;
      switch ( xc_is ) {
        case 0: // red 
          if ( _g >= _b )
             h_ = (120*(_g-_b)+diff)/diff2;
          else
             h_ = (120*(_g-_b+diff)+diff)/diff2 + 300;
          break;
        case 1:  // green 
          if ( _b > _r )
             h_ = 120 + (120*(_b-_r)+diff)/diff2;
          else
             h_ = 60  + (120*(_b-_r+diff)+diff)/diff2;
          break;
       case 2:   // blue
          if ( _r > _g )
            h_ = 240 + (120*(_r-_g)+diff)/diff2;
          else
            h_ = 180 + (120*(_r-_g+diff)+diff)/diff2;
          break;
      }
    } 
  }
  
  /** try to make current hsv lighter if _k>=1.0f, or darker (0<1) */
  public void lighter( float _k )
  {
     if ( _k <= 0 ) return ;// what is a negative color is this world ?
     v_ = (int)(_k*v_);
     if ( v_ > 255 ) //too much light
     {
       s_ = s_-v_+255;   // tune saturation value
       if ( s_ < 0 ) s_ = 0;
       v_ = 255;
     }
  }
}
