/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HSVSWT.java,v 1.2 2008/05/23 14:11:56 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drawutil.internal;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

/**
 * Extends HSV class with method dealing with SWT objects.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class HSVSWT extends HSV
{
  
  public HSVSWT( Color _clr )
  {
    this( _clr.getRGB() );
  }
  public HSVSWT( RGB _rgb )
  {
    super( _rgb.red, _rgb.green, _rgb.blue );
  }
  public HSVSWT( int _r, int _g, int _b )
  {
    super( _r, _g, _b );
  }
  public HSVSWT( int _rgba )
  {
    super( _rgba );
  }
  
  public RGB toRGB( RGB _rgb )
  {
//throw a SWT error instead ?  but, I definitively don't like SWT error  
    if ( h_ < -1 ) return _rgb;
    if ( s_ > 255) return _rgb;
    if ( v_ > 255) return _rgb;
    //hsv hold non chromatic color (!)
    if ( s_ == 0 || h_ == -1 )
    {      
      //achromatic case means grey scale.
      //don't know how to do with that...
      _rgb.red = _rgb.green = _rgb.blue = v_;
      return _rgb;
    } 

    int r=v_, g=v_, b=v_;
     
    if ( h_ >= 360 ) h_ %= 360;
    int _60thn = h_%60;
    h_ /= 60;
    int primary = (2*v_*(255-s_)+255)/510;
    
    int sdist = (h_&0x1)!=0 ? _60thn : (60-_60thn);
    int c = (2*v_*(0x3BC4-(s_*sdist))+0x3BC4)/0x7788;
    switch( h_ )
    {
      case 0: r=v_; g=c;  b=primary;  break;
      case 1: r=c;  g=v_; b=primary;  break;
      case 2: r=primary;  g=v_; b=c;  break;
      case 3: r=primary;  g=c;  b=v_; break;
      case 4: r=c;  g=primary;  b=v_; break;
      case 5: r=v_; g=primary;  b=c;  break;
    }
    _rgb.red   = r;
    _rgb.green = g;
    _rgb.blue  = b;
    return _rgb;
  }
    
}
