/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Point3D.java,v 1.2 2008/05/23 14:11:57 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 25 juin 2003
 *
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

/**
 * Store a 3 dimensional point.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Point3D
{
  protected double x_, y_, z_;
  
  /** Create a point at coordinate (0,0,0) */
  public Point3D()
  {
    x_=y_=z_=0.0f;
  }
  
  /** Create a point with coordinates */
  public Point3D( double _x, double _y, double _z )
  {
    x_=_x; y_=_y; z_=_z;
  }
  
  /** Create a point copying coordinates */
  public Point3D( Point3D _p )
  {
    x_=_p.x_;
    y_=_p.y_;
    z_=_p.z_;
  }
  
  /** @return X coordinate of the point */
  public double getX() { return x_; }
  /** @return Y coordinate of the point */
  public double getY() { return y_; }
  /** @return Y coordinate of the point */
  public double getZ() { return z_; }
  
  /** Change X coordinate of the point */
  public void setX( double _x ) { x_=_x; }
  /** Change Y coordinate of the point */
  public void setY( double _y ) { y_=_y; }
  /** Change Z coordinate of the point */
  public void setZ( double _z ) { z_=_z; }
  
  /** Change both coordinate of the point */
  public void setCoord( double _x, double _y, double _z )
  {
    x_=_x;
    y_=_y;
    z_=_z;
  }
  
  /** Change both coordinate copying from given point */
  public void setCoord( Point3D _p )
  {
    x_=_p.x_;
    y_=_p.y_;
    z_=_p.z_;
  }
  
  public String toString()
  {
    String s = getClass().getName()+"["+x_+","+y_+","+z_+"]";
    return s;
  }
}
