/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Rect.java,v 1.4 2008/05/23 14:11:56 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 26 juin 2003
 *
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

/**
 * A Rectangle with a lot of functionnality, that SWT .... ok, nothing
 * 
 * @deprecated since 1.2.1. This could be fully replaced by org.eclipse.tptp.platform.report.igc.util.internal.Rect class.
 * except methods dealing with org.eclipse.swt.graphics.Rectangle (as IGC must be independant from SWT).
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Rect
{
  protected int x_, y_, w_, h_ ;
  
  /** Create 0,0,0,0 rectagle */
  public Rect()
  {
    x_=y_=w_=h_=0;
  }
  /** Create a rectangle */
  public Rect( int _x, int _y, int _w, int _h )
  {
    x_=_x; y_=_y; w_=_w; h_=_h;
  }
  /** Create a rectangle copying value */
  public Rect( Rect _r )
  {
    setRect(_r);
  }
  /** Create a rectangle from SWT' one */
  public Rect( Rectangle _r )
  {
    setRect( _r );
  }
  
  /** @return x of rectangle, top left corner if w>0 and h>0 */
  public int x() { return x_; }
  /** @return y of rectangle, top left corner if w>0 and h>0 */
  public int y() { return y_; }
  /** @return width of the rectangle */
  public int w() { return w_; }
  /** @return height of the rectangle */
  public int h() { return h_; }
  
  /** @return left side of the rectangle */
  public int left() 
  {
    if( w_ >=0 ) return x_; else return x_+w_;
  }
  /** @return right side of the rectangle */
  public int right()
  {
    if( w_ >=0 ) return x_+w_; else return x_;
  }
  /** @return top of the rectangle */
  public int top()
  {
    if( h_ >=0 ) return y_; else return y_+h_;    
  }
  /** @return bottom of the rectangle */
  public int bottom()
  {
    if( h_ >=0 ) return y_+h_; else return y_;
  }
  /** @return center of the rectangle, allocate a Point */
  public Point center()
  {
    return new Point( centerX(), centerY() );
  }
  /** @return x of the center */
  public int centerX() { return x_+(w_>>1); }
  /** @return y of the center */
  public int centerY() { return y_+(h_>>1); }
  
  
  /** Change x value of rectangle */
  public void setX( int _x ) { x_=_x; }
  /** Change y value of rectangle */
  public void setY( int _y ) { y_=_y; }
  /** Change width of the rectangle */
  public void setWidth( int _w ) { w_=_w; }
  /** Change height of the rectangle */
  public void setHeight( int _h ) { h_=_h; }
  /** Change width and height of the rectangle */
  public void setSize( int _w, int _h ) { w_=_w; h_=_h; }
  /** Change width and height of the rectangle using swt's Point. */
  public final void setSize( Point _size ) { setSize(_size.x,_size.y); }
  /** Change x and y value of rectangle */
  public void setLocation( int _x, int _y ) { x_=_x; y_=_y; }
  /** change x and y value of rectangle using swt's point */
  public final void setLocation( Point _p ) { setLocation( _p.x, _p.y ); }
 

  /**Change left side of the rectangle, right side is not affected, may change width. */
  public void setLeft( int _l )
  {
    int r = right();
    x_ = _l;
    w_ = r-_l;
  }
  /** Change right side of the rectangle, left side is not affected, may change width. */
  public void setRight( int _r )
  {
    int l = left();
    x_ = l;
    w_ = _r-l;
  }
  /** Change top side of the rectangle, bottom is not affected, mau change height */
  public void setTop( int _t )
  {
    int b = bottom();
    y_ = _t;
    h_ = b-_t;
  }
  /** Change bottom side of the rectangle, top is not affected, may change height */
  public void setBottom( int _b )
  {
    int t = top();
    y_ = t;
    h_ = _b-t;
  }
  /** change all bounds using same amount, positive value make bigger rectangle */
  public void grow( int _amount )
  {
    x_ -= _amount; w_ += 2*_amount;
    y_ -= _amount; h_ += 2*_amount;
  }
  /** change all bounds using same amount, positive value make smaller rectangle */
  public void shrink( int _amount )
  {
    x_ += _amount; w_ -= 2*_amount;
    y_ += _amount; h_ -= 2*_amount;
  }
  /**
   * @return true if points (px,py) is inside rectangle (lx,ty,w,h), excluding border.
   */
  public static boolean Contains( int _lx, int _ty, int _w, int _h, int _px, int _py )
  {
    if( _px < _lx ) return false;
    if( _px > (_lx+_w)) return false;
    if( _py < _ty ) return false;
    if( _py > (_ty+_h)) return false;
    return true;
  }
  /**
   * @return true if points (px,py) is inside rectangle (lx,ty,w,h), including border.
   */
  public static boolean ContainsBorder( int _lx, int _ty, int _w, int _h, int _px, int _py )
  {
    if( _px <= _lx ) return false;
    if( _px >= (_lx+_w)) return false;
    if( _py <= _ty ) return false;
    if( _py >= (_ty+_h)) return false;
    return true;
  }
  /** @return true if point is inside rectangle.
   * border of the rectangle is not included in test. */
  public boolean contains( int _px, int _py )
  {
    if( _px < left() ) return false;
    if( _px > right() ) return false;
    if( _py < top() ) return false;
    if( _py > bottom() ) return false;
    return true;
  }
  /** @return true is point is inside rectangle.
   * border of the rectangle is included in test. */
  public boolean containsBorder( int _px, int _py )
  {
    if( _px <= left() ) return false;
    if( _px >= right() ) return false;
    if( _py <= top() ) return false;
    if( _py >= bottom() ) return false;
    return true;
  }
  /** @see #contains */
  public final boolean contains( Point _p ) 
  {
    if( _p==null ) return false;
    return contains( _p.x, _p.y );
  }
  /** @see #containsBorder */
  public final boolean containsBorder( Point _p ) 
  {
    if( _p==null ) return false;
    return contains( _p.x, _p.y );
  }

  /** Change rectangle values */
  public void setRect( int _x, int _y, int _w, int _h )
  {
    x_=_x; y_=_y; w_=_w; h_=_h;
  }
  /** Change rectangle values */
  public void setRect( Rect _r )
  {
    if( _r==null )
    {
      x_=y_=w_=h_=0;
    } else {
      x_=_r.x_; y_=_r.y_; w_=_r.w_; h_=_r.h_;
    }
  }
  /** Change rectangle values */
  public void setRect( Rectangle _r )
  {
    if( _r==null )
    {
      x_=y_=w_=h_=0;
    } else {
      x_=_r.x; y_=_r.y; w_=_r.width; h_=_r.height;
    }
  }
  
  /** @return swt's rectangle */
  public Rectangle toRectangle()
  {
    return new Rectangle( x_, y_, w_, h_ );
  }
  /** @return swt's rectangle filling the field of parameter */
  public Rectangle toRectangle( Rectangle _r )
  {
    if( _r==null ) return new Rectangle( x_,y_,w_,h_ );
    _r.x = x_; _r.y=y_; _r.width=w_; _r.height=h_;
    return _r;
  }
  
  /** Normalize rectangle, set width and height >=0.
   * @return this.
   */
  public Rect normalize()
  {
    if( w_ < 0 ) { x_ += w_; w_=-w_; }
    if( h_ < 0 ) { y_ += h_; h_=-h_; }
    return this;
  }
  
  /** Move rectangle to position */
  public void moveTo( int _x, int _y )
  {
    x_=_x; y_=_y;
  }
  /** Move rectangle by delta */
  public void moveBy( int _dx, int _dy )
  {
    x_+=_dx; y_+=_dy;
  }
  /** Move center of rectangle to given position */
  public void moveCenter( int _cx, int _cy )
  {
    x_ = _cx-(w_>>1);
    y_ = _cy-(h_>>1);
  }
  /** Move center of rectangle to given position */
  public final void moveCenter( Point _p )
  {
    moveCenter( _p.x, _p.y );
  }
  
  /** Setup this rect with the intersection area of this and parameter.
   * return width or height==0 if rectangle doesn't intersects.
   * @return this.
   */
  public Rect intersection( Rect _r )
  {
    int left = Math.max( this.left(),   _r.left()   );
    int top  = Math.max( this.top(),    _r.top()    );
    int right= Math.min( this.right(),  _r.right()  );
    int bottom=Math.min( this.bottom(), _r.bottom() );
    x_ = left;
    y_ = top;
    w_ = Math.max( 0, right-left );
    h_ = Math.max( 0, bottom-top ); 
    return this;
  }
  
  /** Setup this rect with the union of this and parameter.
   * @return this.
   */
  public Rect union( Rect _r )
  {
    int left = Math.min( this.left(),   _r.left()  );
    int top  = Math.min( this.top(),    _r.top()   );
    int right= Math.max( this.right(),  _r.right() );
    int bottom=Math.max( this.bottom(), _r.bottom());
    x_ = left;
    y_ = top;
    w_ = Math.max( 0, right-left );
    h_ = Math.max( 0, bottom-top );
    return this;
  }
  
  /**@return the intersection area of the both rectangle, this is a new allocated rectangle.
   */
  public static Rect Intersection( Rect _r1, Rect _r2 )
  {
    Rect r = new Rect(_r1);
    return r.intersection( _r2 );
  }
  
  /** @return the intersection area of both rectangle, null for no intersection */
  public static Rect Intersection( int x1, int y1, int w1, int h1,  int x2, int y2, int w2, int h2 )
  {
    int l1,r1,t1,b1,  l2,r2,t2,b2;
    if( w1 >= 0 ) { l1=x1; r1=x1+w1; } else { l1=x1+w1; r1=x1; }
    if( h1 >= 0 ) { t1=y1; b1=y1+h1; } else { t1=y1+h1; b1=y1; }
    if( w2 >= 0 ) { l2=x2; r2=x2+w2; } else { l2=x2+w2; r2=x2; }
    if( h2 >= 0 ) { t2=y2; b2=y2+h2; } else { t2=y2+h2; b2=y2; }
    
    int left = Math.max( l1, l2 );
    int right= Math.min( r1, r2 );
    int w = right-left;
    if( w < 0 ) return null;
    
    int top   = Math.max( t1, t2 );
    int bottom= Math.min( b1, b2 );
    int h     = bottom-top ;
    if( h < 0 ) return null;
    
    return new Rect(left,top,w,h);
  }
  
  /** @return the intersection area of both rectangle, null for no intersection */
  public static Rectangle IntersectionR( int x1, int y1, int w1, int h1,  int x2, int y2, int w2, int h2 )
  {
    int l1,r1,t1,b1,  l2,r2,t2,b2;
    if( w1 >= 0 ) { l1=x1; r1=x1+w1; } else { l1=x1+w1; r1=x1; }
    if( h1 >= 0 ) { t1=y1; b1=y1+h1; } else { t1=y1+h1; b1=y1; }
    if( w2 >= 0 ) { l2=x2; r2=x2+w2; } else { l2=x2+w2; r2=x2; }
    if( h2 >= 0 ) { t2=y2; b2=y2+h2; } else { t2=y2+h2; b2=y2; }
    
    int left = Math.max( l1, l2 );
    int right= Math.min( r1, r2 );
    int w = right-left;
    if( w < 0 ) return null;
    
    int top   = Math.max( t1, t2 );
    int bottom= Math.min( b1, b2 );
    int h     = bottom-top ;
    if( h < 0 ) return null;
    
    return new Rectangle(left,top,w,h);
  }

  /** @return bounding rectangle of both given rectangle, this is a new allocated rects */
  public static Rect Union( Rect _r1, Rect _r2 )
  {
    Rect r = new Rect( _r1 );
    return r.union( _r2 );
  }
  
  /** return rectangle as "X,Y,WxH" */
  public String toString()
  {
    String s = x_+","+y_+","+w_+"x"+h_;
    return s;
  }
  
  /**
   * @return true if given object is equals (x,y,w,h) to current object. Object can be a swt.Rectangle
   * or Rect
   */
  public boolean equals( Object o )
  {
    if( o==this) return true;
    if( o instanceof Rect ) 
    { 
      Rect or = (Rect)o;
      return ( or.x_ == x_ ) && (or.y_ == y_ ) && (or.h_ == h_) && (or.w_ == w_);
    }
    if( o instanceof Rectangle ) 
    { 
      Rectangle or = (Rectangle)o;
      return ( or.x == x_ ) && (or.y == y_ ) && (or.height == h_) && (or.width == w_);
    }
    return false;
  }
  
}
