/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SWTDStyle.java,v 1.3 2008/12/12 22:22:09 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 3 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

import java.util.HashMap;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;

import com.ibm.icu.util.ULocale;

/**
 * This class is made to transform any IDStyle applied on a IDItem, to a valid
 * style suitable for SWT widget/drawings.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SWTDStyle implements IDisposable
{
  /**
   * Because getFont() may return a system's default font, the user MUST not
   * dispose. This class holds the returned font and a flag to know disposable policy. 
   */
  public static class SFont
  {
  	private Font font_;
  	private boolean do_dispose_;
  	private static HashMap _defaultFont = new HashMap();
  	
  	public SFont( Font font, boolean do_dispose)
  	{
  		font_ = font;
  		do_dispose_ = do_dispose;
  	}
  	public SFont()
  	{
  		do_dispose_=false;
  	}
  	
  	public Font getFont() { return font_;	}
  	public boolean isDisposable() { return do_dispose_; }
  	public boolean isDisposed() { return font_==null;	}
  	public void dispose()
  	{
  		if( font_!=null && do_dispose_) font_.dispose();
  		font_=null;
  		do_dispose_=false;
  	}
	public void setFont( Font font, boolean do_dispose )
	{
		font_=font; do_dispose_=do_dispose;
	}
  }

  /**
   * Because getColor() may return a system's default color, the user MUST not
   * dispose. This class holds the returned color and a flag to know disposable policy. 
   */
  public static class SColor
  {
	private Color color_;
	private boolean do_dispose_;

	public SColor( Color color, boolean do_dispose)
	{
		color_ = color;
		do_dispose_ = do_dispose;
	}
	public SColor()
	{
		do_dispose_=false;
	}
  	
	public Color getColor() { return color_;	}
	public boolean isDisposable() { return do_dispose_; }
	public boolean isDisposed() { return color_==null;	}
	public void dispose()
	{
		if( color_!=null && do_dispose_) color_.dispose();
		color_=null;
		do_dispose_=false;
	}
	public void setColor( Color color, boolean do_dispose )
	{
		color_=color; do_dispose_=do_dispose;
	}
  }
      
  /** style's current font */
  protected Font font_;
  /** style's current fore color */
  protected Color fore_;
  /** style's current back color */
  protected Color back_;    

  protected boolean dispose_font_, dispose_back_, dispose_fore_;

  protected int font_style_;
 
  /** 
   * Create default style.
   * This is your responsability to call dispose() method.
   */
  public SWTDStyle( Device _dev)
  {
    styleOf( _dev, null, 1.0f );
  }
  
  /** 
   * Create default style.
   * This is your responsability to call dispose() method.
   */
  public SWTDStyle( Device _dev, float font_scale )
  {
    styleOf( _dev, null, font_scale);
  }

    /**
   * Create a style from given IDItem, same result as calling styleOf(item).
   * This is your responsability to call dispose() method.
   */
  public SWTDStyle( Device dev, IDItem _item )
  {
    styleOf( dev, _item, 1.0f );
  }
  
  /**
   * Create a style from given IDItem, same result as calling styleOf(item).
   * This is your responsability to call dispose() method.
   */
  public SWTDStyle( Device dev, IDItem _item, float font_scale )
  {
	  styleOf( dev, _item, font_scale );
  }

  /**
   * Call this to dispose color and fonts allocated by this object.
   * You need to do this to assure SWT requirement.
   */
  public void dispose()
  {
    if(font_!=null && dispose_font_ ) font_.dispose();
    if(fore_!=null && dispose_fore_ ) fore_.dispose();
    if(back_!=null && dispose_back_ ) back_.dispose();
    font_ = null; dispose_font_ = false;
    fore_ = null; dispose_fore_ = false;
    back_ = null; dispose_back_ = false;
  }
  
  /**
   * @return font of this style.
   */
  public Font getFont() { return font_; }
  /**
   * @return fore color of this style.
   */
  public Color getFore() { return fore_ ; }
  /**
   * @return back color of this style.
   */
  public Color getBack() { return back_ ; }
  
  /**
   * @return font style including UNDERLINE,DASHED,... all that Font can't handle.
   */
  public int getFontStyle() { return font_style_; }
  
  /**
   * @return the default fore ground color (black). This color MUST not be disposed.
   */
  public static Color getDefaultFore(Device dev_)
  {
    return dev_.getSystemColor( SWT.COLOR_BLACK );
  }
  
  /**
   * @return the default back ground color (white). This color MUST not be disposed.
   */
  public static Color getDefaultBack(Device dev_)
  {
    return dev_.getSystemColor( SWT.COLOR_WHITE );
  }
  
  /**
   * @return default font (as provided but swt Display).  This font MUST not be disposed.
   */
  public static Font getDefaultFont(Device dev_, float font_scale)
  {	
  	Float fh = new Float(font_scale);
  	Font f = (Font)SWTDStyle.SFont._defaultFont.get(fh);
  	if (f==null)
  	{
  	   f = new Font(dev_, "", (int)(8*font_scale), SWT.NORMAL);
	   SWTDStyle.SFont._defaultFont.put(fh, f);
  	}
  	return f;
  } 

  //?? multi thread aware ?
  private static SColor a_scolor = new SColor();
  private static SFont  a_sfont   = new SFont();
  /** 
   * Dispose current style and change this SWTDStyle with style collected from given IDItem.
   * DStyle for item is retrieved walking upstair in tree from _item to try to find complete style.
   * On top level node, complete style by defaults.
   * The contract is after this, SWTDStyle have non null two colors and fonts .
   * The parameter scale_font is float value 0..+oo which you can obtain a font bigger or lower
   * that the original font. Use for zoom feature. 
   */
  public void styleOf( Device _swt_device, IDItem _item, float font_scale )
  {
    dispose();

    IDStyle jscrib_style=null;
    IDFont  jscrib_font =null;
    IDColor jscrib_color=null;
    int all = 0;
    
    for( IDItem item=_item; item!=null; item=item.getParent() )
    {
      if( (jscrib_style=item.getStyle())!=null )
      {
        //font
        if ( font_==null && (jscrib_font=jscrib_style.getFont())!=null ) 
        {           
          a_sfont = getFont( _swt_device, jscrib_font, font_scale, a_sfont ); 
          dispose_font_ = a_sfont.isDisposable();
          font_ = a_sfont.getFont();
          font_style_ = jscrib_font.getStyle();
          all++;
        }
        //fore color
        if ( fore_==null && (jscrib_color=jscrib_style.getForeColor())!=null )
        {
          a_scolor = getColor( _swt_device, jscrib_color, a_scolor );
          dispose_fore_ = a_scolor.isDisposable();
          fore_ = a_scolor.getColor();
          all++;
        }
        //back color
        if ( back_==null && (jscrib_color=jscrib_style.getBackColor())!=null )
        {
          a_scolor = getColor( _swt_device, jscrib_color, a_scolor );
          dispose_back_ = a_scolor.isDisposable();
          back_ = a_scolor.getColor();
          all++;
        }
        //style completed ?
        if( all==3 ) return ;
      }
    }//for
    
    //get default for missing component
    if ( font_==null ) 
    {           
      font_ = getDefaultFont(_swt_device, font_scale);
         
      font_style_ = DFont.NORMAL;
    }
    //fore color
    if ( fore_==null )
    {
      fore_ = getDefaultFore(_swt_device);
    }
    //back color
    if ( back_==null )
    {
      back_ = getDefaultBack(_swt_device);
    }
  }
  
  public void styleOf( Device _swt_device, IDItem _item)
  {
	styleOf(_swt_device, _item, 1.0f);
  }

  /** 
   * Convert a jscrib font to SWT one.
   * @return a SWT Font object, dispose is under the responsability of the caller of this method.
   *         if _scrib_font is null, return the default font.
   * @param _swt_device the devie used to create font
   * @param _jscrib_font the font to convert
   * @param _font_scale zoom average for the font
   * @param _sfont reuse this object rather than allocate a new one.
   */
  public static SFont getFont( Device _swt_device, IDFont _jscrib_font, float _font_scale, SFont _sfont )
  {
  	if( _sfont == null ) _sfont = new SFont();
    if( _jscrib_font == null )
    {
    	_sfont.setFont( getDefaultFont(_swt_device, _font_scale), false);
    	return _sfont;
    } 
    
    int swt_style  = SWT.NONE;
    if( _jscrib_font.haveStyle( DFont.BOLD  ) ) swt_style |= SWT.BOLD;
    if( _jscrib_font.haveStyle( DFont.ITALIC) ) swt_style |= SWT.ITALIC;      
    //TBD:not in SWT: if( _jscrib_font.getUnderline() ) swt_style |=  ?????
    //TBD:not in SWT: DASHED
     
    String ffamily = _jscrib_font.getFamily();
    String fscript = _jscrib_font.getScript();
    int    fsize   = _jscrib_font.getSize();

    //SWT bark when ffamily is empty...
    if( DrawUtil.isEmpty(ffamily)) ffamily="arial";
    if( DrawUtil.isEmpty(fscript)) fscript=ULocale.getDefault().toString();

    if (_font_scale!=1.0f)
	    fsize = (int)(fsize*_font_scale);

    //limit font size...
    if( fsize <= 5 ) fsize=6;

    FontData font_data = new FontData( ffamily, fsize, swt_style );
    font_data.setLocale( fscript );
    Font font = new Font( _swt_device, font_data );
	_sfont.setFont( font, true );
    return _sfont;
  }
  
  public static SFont getFont( Device _swt_device, IDFont _jscrib_font, SFont _sfont )
  {
     return getFont(_swt_device, _jscrib_font, 1.0f, _sfont);
  }
  /**
   * Equivalent to getFont( _swt_device, _jscrib_font, null );
   */
  public final static SFont getFont( Device _swt_device, IDFont _jscrib_font )
  {
     return getFont( _swt_device, _jscrib_font, null );	
  }
  
  /**
   * Convert an jscrib component color range to a valid SWT Color range [0..255].
   * @return a value in range 0..255.
   */
  public static int getColorComponent( int jscrib_color_component )
  {
    if( jscrib_color_component > 255 ) return 255;
    if( jscrib_color_component < 0   ) return   0;
    return jscrib_color_component;
  }
  
  /**
   * Convert a jscrib IDColor to a swt Color. A system color can be returned.
   * @return a new allocated SWT Color, or getDefaultFore().
   * @param _swt_device the device used to create color.
   * @param _jscrib_color the color to convert.
   * @param _scolor reuse this object rather than allocate a new SColor instance.
   */
  public static SColor getColor( Device _swt_device, IDColor _jscrib_color, SColor _scolor )
  {
  	if( _scolor==null ) _scolor = new SColor();
    if( _jscrib_color == null )
    {
    	_scolor.setColor( getDefaultFore(_swt_device), false );
    	return _scolor;
    }    
    int red    = getColorComponent( _jscrib_color.getRed  () );
    int green = getColorComponent( _jscrib_color.getGreen() );
    int blue   = getColorComponent( _jscrib_color.getBlue () );
    _scolor.setColor( new Color( _swt_device,  red, green, blue ), true );
    return _scolor;
  }

  /**
   * Equivalent to getColor( _swt_device, _jscrib_color, null );
   */
  public static SColor getColor( Device _swt_device, IDColor _jscrib_color )
  {
  	 return getColor( _swt_device, _jscrib_color, null );
  }
  
  /** 
   * @return the foreground color use by item or one of its parent, or default foreground.
   * Do not forget to call .dispose() on returned color. If you wan to get fore, back color and
   * font prefer to use SWTDStyle instand of the method.
   */
  public static SColor getForeColor( Device _swt_device, IDItem _item )
  {
    IDStyle jscrib_style=null;
    IDColor jscrib_color=null;
    
    for( IDItem item=_item; item!=null; item=item.getParent() )
    {
      if( (jscrib_style=item.getStyle())!=null )
      {
        if ( (jscrib_color=jscrib_style.getForeColor())!=null )
        {
          return getColor( _swt_device, jscrib_color, null );
        }
      }
    }//for
    
    //return default
    return new SColor( getDefaultFore(_swt_device), false );
  }
  
  /** 
   * @return the background color use by item or one of its parent, or default background.
   * Do not forget to call .dispose() on returned color. If you wan to get fore, back color and
   * font prefer to use SWTDStyle instand of the method.
   */
  public static SColor getBackColor( Device _swt_device, IDItem _item )
  {
    IDStyle jscrib_style=null;
    IDColor jscrib_color=null;
    
    for( IDItem item=_item; item!=null; item=item.getParent() )
    {
      if( (jscrib_style=item.getStyle())!=null )
      {
        if ( (jscrib_color=jscrib_style.getBackColor())!=null )
        {
          return getColor( _swt_device, jscrib_color, null );
        }
      }
    }//for
    
    //return default
    return new SColor( getDefaultBack(_swt_device), false );
  }  
  
  /** 
   * @return the inherited font by a style on the item or a style applied on a parent
   */
  public static SFont getFont( Device _swt_device, IDItem _item, float font_scale )
  { 
	   IDFont f =  getFont( _item);
	   if (f!=null)
		  return getFont( _swt_device, f, font_scale, null );
	   else
		  //	return default
		  return new SFont( getDefaultFont(_swt_device, font_scale), false );
  }  
  
  /** 
	* @return the inherited font by a style on the item or a style applied on a parent
	*/
   public static SFont getFont( Device _swt_device, IDItem _item )
   { 
   	  return getFont(_swt_device, _item, 1.0f);
   }  
   
   /** 
	* @return the inherited font by a style on the item or a style applied on a parent.
	*/
   public static IDFont getFont( IDItem _item )
   {
	  IDStyle jscrib_style=null;
	  IDFont jscrib_font=null;
    
	  for( IDItem item=_item; item!=null; item=item.getParent() )
	  {
		   if( (jscrib_style=item.getStyle())!=null )
		   {
			 if ( (jscrib_font=jscrib_style.getFont())!=null )
			 {
			   return  jscrib_font;
			 }
		   }
	  }//for
	 
	  return null;
   }
   
}
