/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Vector3D.java,v 1.2 2008/05/23 14:11:56 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drawutil.internal;

/**
 * Store a 3 dimensional vector.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Vector3D
{
  protected double x_, y_, z_, n_;
  
  /** Create a (0,0,0) vector */
  public Vector3D()
  {
    x_=y_=z_=n_=0.0f;
  }
  
  /** Create a vector with coordinates */
  public Vector3D( double _x, double _y, double _z )
  {
    setVector( _x, _y, _z );
  }
  
  /** Create a vector copying coordinates */
  public Vector3D( Vector3D _v )
  {
    setVector( _v );
  }
  
  /** @return X coordinate of the vector */
  public double getX() { return x_; }
  /** @return Y coordinate of the vector */
  public double getY() { return y_; }
  /** @return Y coordinate of the vector */
  public double getZ() { return z_; }
  /** @return norm of vector */
  public double getNorm() 
  {
    if( n_ < 0 ) n_ = Math.sqrt( x_*x_ + y_*y_ + z_*z_ );
    return n_; 
  }
  
  /** Change X coordinate of the vector */
  public void setX( double _x ) { x_=_x; n_=-1; }
  /** Change Y coordinate of the vector */
  public void setY( double _y ) { y_=_y; n_=-1; }
  /** Change Z coordinate of the vector */
  public void setZ( double _z ) { z_=_z; n_=-1; }
  
  /** Change both coordinate of the point */
  public void setVector( double _x, double _y, double _z )
  {
    x_=_x;
    y_=_y;
    z_=_z;
    n_=-1;
  }
  
  /** Change both coordinate copying from given point */
  public void setVector( Vector3D _v )
  {
    x_=_v.x_;
    y_=_v.y_;
    z_=_v.z_;
    n_=_v.n_;
  }
  
  public String toString()
  {
    String s = super.toString()+"["+x_+","+y_+","+z_+"]";
    return s;
  }
  
  public void normalize()
  {
    if( n_ < 0 ) getNorm();
    if( n_!=1.0 )
    {
      if( n_!=0.0 )
      {
        x_ /= n_;
        y_ /= n_;
        z_ /= n_;
      }
      n_=1.0;
    }
  }
  
  public static double Scalar( Vector3D v1, Vector3D v2 )
  {
    return v1.x_*v2.x_ + v1.y_*v2.y_ + v1.z_*v2.z_;
  }
  
  /** Change current vector coordinate by result of vectorial product */
  public void vectorialProduct( double x1,double y1,double z1, double x2,double y2,double z2 )
  {
     x_ =  y1*z2 - z1*y2;
     y_ = -x1*z2 + z1*x2;
     z_ =  x1*y2 - y1*x2;
     n_ = -1.0;
  }
  
  /** negative vector, x,y,z are replaced by -x,-y,-z */
  public void negative()
  {
    x_ = -x_;
    y_ = -y_;
    z_ = -z_;
  }
}
