/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DAbstractDocumentPolicy.java,v 1.4 2008/05/23 14:11:49 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.drivers.html;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

import javax.imageio.ImageIO;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.IDDocument;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.internal.HtmlFile;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.awt.internal.AWTGC;
import org.eclipse.tptp.platform.report.igc.awt.internal.AWTImage;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTImage;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;


/**
 * This interface provides the service to generate valid
 * html link reference.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public abstract class  DAbstractDocumentPolicy implements IDGenerationPolicy {
    
        
    private DHtmlWriter writer;
    private ConfParser confparser;
	private String fileExtension = "html";
	private String baseDirectory;
	private String imageDirectoryName = "images";
	private IDIImageProvider imageProvider;
	private IDDocument indexDocument;
    
    public DAbstractDocumentPolicy(DHtmlWriter wh, String basePath, IDIImageProvider imgp)
    {
        writer = wh;
        baseDirectory = basePath;
        imageProvider = imgp;
    }

    /** @return the Html writer */
    public DHtmlWriter getWriter() {
        return writer;
    }
    
    private HashMap _generatedImage = new HashMap();
    
    /** Writes an IImage in the file */
    protected String writeInFile(IImage img) throws DHtmlWriterException
    {
        String image_name = "img"+img.hashCode()+".jpeg";
        String image_filename = getImageDirectoryPath()+File.separatorChar + image_name;
        
        // do not generate existing image
        if (_generatedImage.containsKey(img)) return (String)_generatedImage.get(img);
        
		if (img instanceof SWTImage)
		{   
		    Image swtimg = ((SWTImage)img).getImage();
			
			ImageLoader loader = new ImageLoader();
			if (loader.data == null) {
			    loader.data = new ImageData[1];
			}
			    
			loader.data[0] = swtimg.getImageData();
			try {
			    loader.save(image_filename, SWT.IMAGE_JPEG);
			} catch (SWTException _e) {
			    throw new DHtmlWriterException("Error saving image:" + image_filename + ": " + _e);
			} catch (SWTError _r) {
			        throw new DHtmlWriterException("Error saving image:" + image_filename + ": " + _r);
			}
			_generatedImage.put(img, getImageDirectoryName()+File.separatorChar + image_name);
			return getImageDirectoryName()+File.separatorChar + image_name;
		}
		else
		if (img instanceof AWTImage)
		{
		    
		    java.awt.Image awtimg = ((AWTImage)img).getImage();
		    
		    int w = img.getWidth();
		    int h = img.getHeight();
		    
		    BufferedImage offscreen = new BufferedImage( w, h, BufferedImage.TYPE_INT_RGB ); 
		    AWTGC awtgc = new AWTGC( offscreen.getGraphics() );
		    awtgc.drawImage(img, 0, 0);
		    
		    File file = new File( image_filename );
		    try {
		        ImageIO.write( offscreen, "jpeg", file );
		    } catch( IOException e ) {
		        throw new DHtmlWriterException("Error saving image:" + image_filename + ": " + e);
		    }
		    _generatedImage.put(img, getImageDirectoryName()+File.separatorChar + image_name);
		    return getImageDirectoryName()+File.separatorChar + image_name;
		}
		return null;
    }
    
    protected String copyImageFile(String img) throws DHtmlWriterException
    {
        File src = new File(img);
        String image_filename = getImageDirectoryPath()+File.separatorChar + src.getName();
        
        try {
          FileOutputStream fout = new FileOutputStream(image_filename);
          FileInputStream fin = new FileInputStream(img);
          
          byte[] b = new byte[1024];
          int nbread = 0;
          while ((nbread=fin.read(b))!=-1)
          {
              fout.write(b, 0, nbread);
          }
          fout.close();
          fin.close();
        }
        catch (IOException e)
        {
            throw new DHtmlWriterException("Error when copy image file:" + img + " to " + image_filename + ": " + e);
        }
        
        return getImageDirectoryName()+File.separatorChar + src.getName();
    }
    
    
    /** @return the valid url for the image*/
    public String getImageUrl(DImage image) throws DHtmlWriterException
    {
        // check if the image is in the ImageProvider
        if (getImageProvider()!=null)
        {
           IImage img = getImageProvider().getImage(image.getName());
           if (img!=null)
               return writeInFile(img);
        }
        
        // check if the image's name is a URL
        if (image.getName().matches("http:"))
            return image.getName();
        
        // check if the image exists on the disk
        File f = new File(image.getName());
        if (f.exists())
        {
            return copyImageFile(image.getName());
        }
        
        if (getImageProvider()!=null)
        {
           IImage img = getImageProvider().getBrokenImage(); 
           return writeInFile(img);
        }
        
        return image.getName();
    }
    
    
    
    protected void writeInFile(DHtmlWriter writer, String docTitle, IDItem item, DExtensible ext, Object arg) throws DHtmlWriterException
    {
		  writer.getConfparser().setVariableValue("DOCUMENT_TITLE", docTitle, item);
		  writer.getConfparser().setVariableValue("HTML_BGCOLOR", "=\"#ffffff\"", item);

		  writer.getTitleLevel().setMax(writer.getConfparser().getHtmlFile().getMaxTitleLevel() - 1);
		  HtmlFile hf = writer.getConfparser().getHtmlFile();
		
		  writer.htmlDump(hf.getBegin());
		
		  writer.doChildrenItem(item, ext, arg);
	
		  writer.htmlDump(hf.getEnd());      
    }
    
    /** */
    public void doMethod(DPopup item, DExtensible ext, Object arg) throws DHtmlWriterException
    {
        DHtmlWriter writer = (DHtmlWriter)ext;
        
        String filepath = getBaseDirectoryPath() + File.separatorChar + item.getTag() + "." + getFileExtension();
        OutputStream out = writer.getOutputStream();
        try {
           writer.setOutputStream(new FileOutputStream(filepath));
           writeInFile(writer, item.getTag(), item,  ext, arg);
           writer.getOutputStream().close();
           writer.setOutputStream(out);
        }
        catch (FileNotFoundException e)
        {
           throw new DHtmlWriterException("Document Generation Error: unable to generate the file '" + filepath +"' ("+e.getMessage()+")");
        }
        catch (IOException e)
        {
            throw new DHtmlWriterException(e.getMessage());
        }

    }
    
    
    /** @return the file extension for the HTML file. By default return ".html" */
    public String getFileExtension() {
        return fileExtension;
    }
    
    /** Sets the file extension for the HTML file */
    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }
    
    /**
	 * Sets the destination directory for HTML files.
	 */
	public void setBaseDirectoryPath(String dirname) {
		this.baseDirectory = dirname;
	}

	/**
	 * @return the destination directory for HTML files.
	 */
	public String getBaseDirectoryPath() {
		return baseDirectory;
	}
    
    /** @return the image directory path */
    public String getImageDirectoryPath()
    {
       return getBaseDirectoryPath() + File.separatorChar + getImageDirectoryName();   
    }
    
    /** Creates the directory */
    public void start()
    {
       File f = new File(getBaseDirectoryPath());
       if (!f.exists())
           f.mkdir();
       
       f = new File(getImageDirectoryPath());
       if (!f.exists())
           f.mkdir();
    }
    
    /** @return the image directory name. By default returns 'images'. */
    public String getImageDirectoryName() {
        return imageDirectoryName;
    }
    
    /** Sets the image directory name. */
    public void setImageDirectoryName(String imageDirectoryName) {
        this.imageDirectoryName = imageDirectoryName;
    }
    
    /** @return the Image provider */
    public IDIImageProvider getImageProvider() {
        return imageProvider;
    }
   
}
