/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DHtmlGraphicImageAWT.java,v 1.5 2008/05/23 14:11:49 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.html;


import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.core.internal.*;
import org.eclipse.tptp.platform.report.drivers.internal.Item;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.awt.internal.AWTGC;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.render.internal.DRenderRegistry;
import org.eclipse.tptp.platform.report.render.internal.IRender;
import org.eclipse.tptp.platform.report.render.internal.NullRenderMonitor;


/**
 * This class uses the JScrib DExtensible extension mechanism to provide an optionnal way to translate
 * DGraphic items to html creating an image for each DGraphic.
 * This class require only AWT classes, no SWT dependency.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DHtmlGraphicImageAWT 
{
  
  private void graphicDump( DGraphic graphic, float scale, DHtmlWriter driver )
  {
    if( driver.getGenerationPolicy()==null ) return ;
    
    String path = driver.getGenerationPolicy().getImageDirectoryPath() + File.separatorChar;
    String image_filename = path + driver.getConfparser().getVariableValue("HTML_GRAPHIC_FILE_NAME");
    int w = 500, h = w;
    w *= graphic.getWidthScale();
    h *= graphic.getHeightScale();
    Rect rect = new Rect(0, 0, w, h);
    
    BufferedImage offscreen = new BufferedImage( w, h, BufferedImage.TYPE_INT_RGB ); 
    AWTGC awtgc = new AWTGC( offscreen.getGraphics() );
    
    IRender render = DRenderRegistry.GetRender( graphic );
    render.draw( awtgc, rect, graphic, scale, driver.getGenerationPolicy().getImageProvider(), new NullRenderMonitor(), null );
    
    File file = new File( image_filename );
    try {
      ImageIO.write( offscreen, "png", file );
    } catch( IOException e ) {
      e.printStackTrace();
    }
  }
  
  public void doMethod(DGraphic item, DExtensible ext, Object arg)  throws DHtmlWriterException
  {
    DHtmlWriter driver = (DHtmlWriter)ext;
    Item hitem = driver.getItem(item);
    driver.updateStyleVariables(item);
    ConfParser confparser = driver.getConfparser();
    String title = DefaultChartRenderData.getResourceString(item.getTitle(), 
            (DI18N)item.getChildOfClass(DI18N.class));
    confparser.setVariableValue("GRAPHIC_TITLE", title, item);
    confparser.setVariableValue("GRAPHIC_WIDTH", Float.toString(item.getWidthScale()), item);
    confparser.setVariableValue("HTML_GRAPHIC_WIDTH", Integer.toString((int) (item.getWidthScale() * 100.0f)), item);
    confparser.setVariableValue("GRAPHIC_HEIGHT", Float.toString(item.getHeightScale()), item);
    confparser.setVariableValue("HTML_GRAPHIC_FILE_NAME", "img" + Integer.toHexString(item.hashCode()) +".png", item);
    driver.htmlDump(hitem.getBegin());
    graphicDump( item, 1.0f, driver );
    driver.htmlDump(hitem.getEnd());
    confparser.unsetVariables(item);
  }

}
