/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DHtmlGraphicImageSWT.java,v 1.5 2008/05/23 14:11:49 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 24 nov. 2003
 */
package org.eclipse.tptp.platform.report.drivers.html;

import java.io.File;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.SWTError;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.core.internal.*;
import org.eclipse.tptp.platform.report.drivers.internal.Item;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.render.internal.RenderableSnapShot;


/**
 * This class uses the JScrib DExtensible extension mechanism to provide an optionnal way to translate
 * DGraphic items to html by te mean of a JPEG image.
 * If it is not delivered with the DHtmlWriter class, a default implementation for DGraphic items
 * translation is taken: do nothing.
 * This class is the only one from that package that requires SWT.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DHtmlGraphicImageSWT 
{
	
	private void graphicDump(Device dev, DGraphic graphic, float scale, DHtmlWriter driver ) 
	{
	    if( driver.getGenerationPolicy()==null ) return ;
	    
	    String path = driver.getGenerationPolicy().getImageDirectoryPath() + File.separatorChar;
	    String image_filename = path +  driver.getConfparser().getVariableValue("HTML_GRAPHIC_FILE_NAME");
		int w = 500, h = w;
		w *= graphic.getWidthScale();
		h *= graphic.getHeightScale();
		Rect r = new Rect(0, 0, w, h);

		Image img = RenderableSnapShot.Process(dev, r, graphic, scale, driver.getGenerationPolicy().getImageProvider() );
		ImageLoader loader = new ImageLoader();
		if (loader.data == null) {
			loader.data = new ImageData[1];
		}
		loader.data[0] = img.getImageData();
		try {
			loader.save(image_filename, SWT.IMAGE_JPEG);
		} catch (SWTException _e) {
			System.err.println("Error saving image:" + image_filename + ": " + _e);
		} catch (SWTError _r) {
			System.err.println("Error saving image:" + image_filename + ": " + _r);
		}
		img.dispose();
	}

	public void doMethod(DGraphic item, DExtensible ext, Object arg)  throws DHtmlWriterException
	{
		DHtmlWriter driver = (DHtmlWriter)ext;
		Item hitem = driver.getItem(item);
		driver.updateStyleVariables(item);
		ConfParser confparser = driver.getConfparser();
        String title = DefaultChartRenderData.getResourceString(item.getTitle(), 
                (DI18N)item.getChildOfClass(DI18N.class));
		confparser.setVariableValue("GRAPHIC_TITLE", title, item);
		confparser.setVariableValue("GRAPHIC_WIDTH", Float.toString(item.getWidthScale()), item);
		confparser.setVariableValue("HTML_GRAPHIC_WIDTH", Integer.toString((int) (item.getWidthScale() * 100.0f)), item);
		confparser.setVariableValue("GRAPHIC_HEIGHT", Float.toString(item.getHeightScale()), item);
		confparser.setVariableValue("HTML_GRAPHIC_FILE_NAME", "img" + Integer.toHexString(item.hashCode())+".jpeg", item);
		driver.htmlDump(hitem.getBegin());
		graphicDump(Display.getDefault(), item, 1.0f, driver );
		driver.htmlDump(hitem.getEnd());
		confparser.unsetVariables(item);
	}

}
