/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DHtmlGraphicSVG.java,v 1.11 2008/05/23 14:11:49 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.html;


import java.io.File;

import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.chart.svg.internal.SVGGenerator;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriter;
import org.eclipse.tptp.platform.report.drivers.internal.ConfSemanticException;
import org.eclipse.tptp.platform.report.drivers.internal.Item;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;

/**
 * This class uses the JScrib DExtensible extension mechanism to generate DGraphic
 * items into html using SVG format.
 */
public class DHtmlGraphicSVG
{
	private DHtmlWriter driver;
	private ConfParser confparser;
	
	public DHtmlGraphicSVG()
	{
	}
	
	public ConfParser getConfParser()
	{
	  return confparser;
	}

	private boolean initialized;
	
	private void initConfParser( ConfParser parent )
	{
	  if( initialized )
	  {
	    confparser.setParentConfParser( parent );
	    return ;
	  }
	  
	  confparser = new ConfParser("dhtmlgraphicsvg.xml", parent )
	  {
	    protected void checkItemChild( Item item, Node n ) throws ConfSemanticException
	    {
	      /*if( n.getNodeType() == Node.ELEMENT_NODE && "property".equals( n.getNodeName() ) ) //$NON-NLS-1$
	      {
	        Element e = (Element)n;
	        String name = e.getAttribute("name");
	        String value = e.getAttribute("value");
	        if( name==null ) 
	          throw new ConfSemanticException("missing 'name' attribute in 'property' element");
	        if( "data".equals(name) ) checkPropertyData( value );
	        else if( "copyjarfile".equals(name)) checkPropertyCopyJarFile( value );
	        else if( "encode".equals(name)) checkPropertyEncode( value );
	      }*/
	    }
	    private void  checkPropertyData( String value ) throws ConfSemanticException
	    {
	      /*if( value==null || "best".equals(value) )
	        format_ = F_BEST;
	      else if( "zip".equals(value) )
	        format_ = F_ZIP;
	      else if( "direct".equals(value) )
	        format_ = F_DIRECT;
	      else
	        throw new ConfSemanticException("Unknown '"+value+"' value for 'data' property");*/
	    }
	    private void  checkPropertyCopyJarFile( String value ) throws ConfSemanticException
	    {
	      /*if( value==null || "auto".equals(value) )
	        copy_jar_file_ = C_AUTO;
	      else if( "always".equals(value) )
	        copy_jar_file_ = C_ALWAYS;
	      else if( "never".equals(value) )
	        copy_jar_file_ = C_NEVER;
	      else
	        throw new ConfSemanticException("Unknown '"+value+"' value for 'copyjarfile' property");*/
	    }
	    private void  checkPropertyEncode( String value ) throws ConfSemanticException
	    {
	      /*if( value==null || "default".equals(value) )
	        encode_ = ChartEncoderOutputStream.E_DEFAULT;
	      else if( "forjavascript".equals(value) )
	        encode_ = ChartEncoderOutputStream.E_FORJAVASCRIPT;
	      else if( "all".equals(value) )
	        encode_ = ChartEncoderOutputStream.E_ALL;
	      else
	        throw new ConfSemanticException("Unknown '"+value+"' value for 'encode' property");*/
	    }
	  };
	  
	  //initialize specific variable for this piece of code
	  confparser.initVariable("HTML_APPLET_PARAM_NAME");
	  confparser.initVariable("HTML_APPLET_PARAM_VALUE");
	  
      if (!confparser.parse()) 
	  {
	     System.err.println("Graphic Applet Html Configuration parsing failed");
	     confparser=null;
	     initialized=false;
	     return;
	  }
      initialized=true;
	}
	
	public void doMethod(DGraphic graphic, DExtensible ext, Object arg) throws DHtmlWriterException
	{
	  driver = (DHtmlWriter)ext;
	  
	  DGraphic oldf = null;
	  if (graphic.getFirstChild() instanceof DGraphic)
	  {
	      oldf = (DGraphic)graphic.getFirstChild();
	      graphic.removeChild(oldf);
	  }
	  
	  //extends driver's configuration parser.
	  ConfParser parent_parser = driver.getConfparser();
	  initConfParser( parent_parser );
	  if( confparser==null ) return ; //error in configuration, no applet.
	  driver.setConfparser( confparser );
	  
	  Item hitem = driver.getItem(graphic);
	  driver.updateStyleVariables(graphic);
	  
	  int width = (int)(500*graphic.getWidthScale());
	  int height= (int)(500*graphic.getHeightScale());
      
      int max_w = graphic.getProperties().get( DGraphic.P_MAX_WIDTH, width );
      int min_w = graphic.getProperties().get( DGraphic.P_MIN_WIDTH, width );
      int max_h = graphic.getProperties().get( DGraphic.P_MAX_HEIGHT, height );
      int min_h = graphic.getProperties().get( DGraphic.P_MIN_HEIGHT, height );
	  
	  File f = new File(driver.getGenerationPolicy().getImageDirectoryPath());
      String name = "gph" + Integer.toHexString(graphic.hashCode())+".svg";
      
	  confparser.setVariableValue("HTML_GRAPHIC_FILE_NAME", f.getName() + "/" + name, graphic);

	  String filename = driver.getGenerationPolicy().getImageDirectoryPath() + "/" + name;
	  
      String title = DefaultChartRenderData.getResourceString(graphic.getTitle(), 
              (DI18N)graphic.getChildOfClass(DI18N.class));
	  confparser.setVariableValue("GRAPHIC_TITLE", title, graphic);
	  confparser.setVariableValue("GRAPHIC_WIDTH", Float.toString(graphic.getWidthScale()), graphic);
	  confparser.setVariableValue("GRAPHIC_HEIGHT", Float.toString(graphic.getHeightScale()), graphic);
	  confparser.setVariableValue("HTML_GRAPHIC_WIDTH", Integer.toString(min_w), graphic);
	  confparser.setVariableValue("HTML_GRAPHIC_HEIGHT", Integer.toString(min_h), graphic);
      
	  try {
	    driver.htmlDump( hitem.getBegin() );
	    
	    try{
	    	 //read common input file
//	    	   FileInputStream inputStream = new FileInputStream("c:\\temp\\Ex.rxml");

	    	 //generate svg chart
	    	   SVGGenerator generator = new SVGGenerator();		
	    	   Chart input = new SVGChartImpl(graphic);
			   input.getConfiguration().getSize().setHeight(min_h);
			   input.getConfiguration().getSize().setWidth(min_w);
	    	   Document svgoutput = generator.generateGraphicDocument(input);

	    	 //write document to file
//	    	   generator.serializeGeneratedDocumentToFile(svgoutput,"c:\\temp\\testjscrib.svg");
	    	   generator.serializeGeneratedDocumentToFile(svgoutput,filename);

	    	}
	    	catch(Exception e)
	    	{
	    		e.printStackTrace();
	    	          System.out.println("Error reading: "+e);
	    	}
	    
//		    FileOutputStream os = new FileOutputStream( filename );
	    
//	    SVGGC gc = new SVGGC( os, width, height );
//	  
//	    IRender render = DRenderRegistry.GetRender( graphic );
//	    gc.begin();
//        render.draw( gc, new Rect(0,0,width,height), graphic, 1.0f, driver.getImageProvider(), new NullRenderMonitor(), null );
//        gc.end();
//	    
//	    driver.htmlDump(hitem.getEnd());
//	    confparser.unsetVariables(graphic);
	  }
	  catch( Exception  e )
	  {
	    e.printStackTrace();
	  }
	  //restore driver parser:
	  confparser.setParentConfParser( null );
	  driver.setConfparser( parent_parser );  
	  
	  if (oldf!=null)
	      graphic.insertChild(oldf, null);
	  
	}

}
